<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProactiveNotification EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: ProactiveNotification
 * - nillable: true
 * - type: tns:ProactiveNotification
 * @subpackage Structs
 */
class ProactiveNotification extends AbstractStructBase
{
    /**
     * The RequestorName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RequestorName;
    /**
     * The RequestorEmail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RequestorEmail;
    /**
     * The Subscriptions
     * Meta information extracted from the WSDL
     * - documentation: Subscriptions - Subscription[]
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfSubscription
     */
    public $Subscriptions;
    /**
     * Constructor method for ProactiveNotification
     * @uses ProactiveNotification::setRequestorName()
     * @uses ProactiveNotification::setRequestorEmail()
     * @uses ProactiveNotification::setSubscriptions()
     * @param string $requestorName
     * @param string $requestorEmail
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfSubscription $subscriptions
     */
    public function __construct($requestorName = null, $requestorEmail = null, \Pepitelabs\PWS\EstimatingService\ArrayOfSubscription $subscriptions = null)
    {
        $this
            ->setRequestorName($requestorName)
            ->setRequestorEmail($requestorEmail)
            ->setSubscriptions($subscriptions);
    }
    /**
     * Get RequestorName value
     * @return string|null
     */
    public function getRequestorName()
    {
        return $this->RequestorName;
    }
    /**
     * Set RequestorName value
     * @param string $requestorName
     * @return \Pepitelabs\PWS\EstimatingService\ProactiveNotification
     */
    public function setRequestorName($requestorName = null)
    {
        // validation for constraint: string
        if (!is_null($requestorName) && !is_string($requestorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestorName, true), gettype($requestorName)), __LINE__);
        }
        $this->RequestorName = $requestorName;
        return $this;
    }
    /**
     * Get RequestorEmail value
     * @return string|null
     */
    public function getRequestorEmail()
    {
        return $this->RequestorEmail;
    }
    /**
     * Set RequestorEmail value
     * @param string $requestorEmail
     * @return \Pepitelabs\PWS\EstimatingService\ProactiveNotification
     */
    public function setRequestorEmail($requestorEmail = null)
    {
        // validation for constraint: string
        if (!is_null($requestorEmail) && !is_string($requestorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestorEmail, true), gettype($requestorEmail)), __LINE__);
        }
        $this->RequestorEmail = $requestorEmail;
        return $this;
    }
    /**
     * Get Subscriptions value
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfSubscription|null
     */
    public function getSubscriptions()
    {
        return $this->Subscriptions;
    }
    /**
     * Set Subscriptions value
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfSubscription $subscriptions
     * @return \Pepitelabs\PWS\EstimatingService\ProactiveNotification
     */
    public function setSubscriptions(\Pepitelabs\PWS\EstimatingService\ArrayOfSubscription $subscriptions = null)
    {
        $this->Subscriptions = $subscriptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\ProactiveNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
