<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Piece EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: Piece
 * - nillable: true
 * - type: tns:Piece
 * @subpackage Structs
 */
class Piece extends AbstractStructBase
{
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - documentation: Weight - Weight
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\Weight
     */
    public $Weight;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: Length - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\Dimension
     */
    public $Length;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: Width - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\Dimension
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: Height - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\Dimension
     */
    public $Height;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - documentation: Options - OptionIDValuePair[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair
     */
    public $Options;
    /**
     * Constructor method for Piece
     * @uses Piece::setWeight()
     * @uses Piece::setLength()
     * @uses Piece::setWidth()
     * @uses Piece::setHeight()
     * @uses Piece::setOptions()
     * @param \Pepitelabs\PWS\EstimatingService\Weight $weight
     * @param \Pepitelabs\PWS\EstimatingService\Dimension $length
     * @param \Pepitelabs\PWS\EstimatingService\Dimension $width
     * @param \Pepitelabs\PWS\EstimatingService\Dimension $height
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair $options
     */
    public function __construct(\Pepitelabs\PWS\EstimatingService\Weight $weight = null, \Pepitelabs\PWS\EstimatingService\Dimension $length = null, \Pepitelabs\PWS\EstimatingService\Dimension $width = null, \Pepitelabs\PWS\EstimatingService\Dimension $height = null, \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair $options = null)
    {
        $this
            ->setWeight($weight)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setOptions($options);
    }
    /**
     * Get Weight value
     * @return \Pepitelabs\PWS\EstimatingService\Weight|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \Pepitelabs\PWS\EstimatingService\Weight $weight
     * @return \Pepitelabs\PWS\EstimatingService\Piece
     */
    public function setWeight(\Pepitelabs\PWS\EstimatingService\Weight $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\Dimension|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\Dimension $length
     * @return \Pepitelabs\PWS\EstimatingService\Piece
     */
    public function setLength(\Pepitelabs\PWS\EstimatingService\Dimension $length = null)
    {
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\Dimension|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\Dimension $width
     * @return \Pepitelabs\PWS\EstimatingService\Piece
     */
    public function setWidth(\Pepitelabs\PWS\EstimatingService\Dimension $width = null)
    {
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
    /**
     * Get Height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\Dimension|null
     */
    public function getHeight()
    {
        return isset($this->Height) ? $this->Height : null;
    }
    /**
     * Set Height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\Dimension $height
     * @return \Pepitelabs\PWS\EstimatingService\Piece
     */
    public function setHeight(\Pepitelabs\PWS\EstimatingService\Dimension $height = null)
    {
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->Height);
        } else {
            $this->Height = $height;
        }
        return $this;
    }
    /**
     * Get Options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair|null
     */
    public function getOptions()
    {
        return isset($this->Options) ? $this->Options : null;
    }
    /**
     * Set Options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair $options
     * @return \Pepitelabs\PWS\EstimatingService\Piece
     */
    public function setOptions(\Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair $options = null)
    {
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->Options);
        } else {
            $this->Options = $options;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\Piece
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
