<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupInformation EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: PickupInformation
 * - nillable: true
 * - type: tns:PickupInformation
 * @subpackage Structs
 */
class PickupInformation extends AbstractStructBase
{
    /**
     * The PickupType
     * Meta information extracted from the WSDL
     * - documentation: Type - PickupType
     * @var string
     */
    public $PickupType;
    /**
     * Constructor method for PickupInformation
     * @uses PickupInformation::setPickupType()
     * @param string $pickupType
     */
    public function __construct($pickupType = null)
    {
        $this
            ->setPickupType($pickupType);
    }
    /**
     * Get PickupType value
     * @return string|null
     */
    public function getPickupType()
    {
        return $this->PickupType;
    }
    /**
     * Set PickupType value
     * @uses \Pepitelabs\PWS\EstimatingService\PickupType::valueIsValid()
     * @uses \Pepitelabs\PWS\EstimatingService\PickupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupType
     * @return \Pepitelabs\PWS\EstimatingService\PickupInformation
     */
    public function setPickupType($pickupType = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\EstimatingService\PickupType::valueIsValid($pickupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\EstimatingService\PickupType', is_array($pickupType) ? implode(', ', $pickupType) : var_export($pickupType, true), implode(', ', \Pepitelabs\PWS\EstimatingService\PickupType::getValidValues())), __LINE__);
        }
        $this->PickupType = $pickupType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\PickupInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
