<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInformation EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: PaymentInformation
 * - nillable: true
 * - type: tns:PaymentInformation
 * @subpackage Structs
 */
class PaymentInformation extends AbstractStructBase
{
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - documentation: PaymentType - PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * The RegisteredAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: RegisteredAccountNumber - string
     * - nillable: true
     * @var string
     */
    public $RegisteredAccountNumber;
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: BillingAccountNumber - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The CreditCardInformation
     * Meta information extracted from the WSDL
     * - documentation: CreditCardInformation - CreditCardInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\CreditCardInformation
     */
    public $CreditCardInformation;
    /**
     * Constructor method for PaymentInformation
     * @uses PaymentInformation::setPaymentType()
     * @uses PaymentInformation::setRegisteredAccountNumber()
     * @uses PaymentInformation::setBillingAccountNumber()
     * @uses PaymentInformation::setCreditCardInformation()
     * @param string $paymentType
     * @param string $registeredAccountNumber
     * @param string $billingAccountNumber
     * @param \Pepitelabs\PWS\EstimatingService\CreditCardInformation $creditCardInformation
     */
    public function __construct($paymentType = null, $registeredAccountNumber = null, $billingAccountNumber = null, \Pepitelabs\PWS\EstimatingService\CreditCardInformation $creditCardInformation = null)
    {
        $this
            ->setPaymentType($paymentType)
            ->setRegisteredAccountNumber($registeredAccountNumber)
            ->setBillingAccountNumber($billingAccountNumber)
            ->setCreditCardInformation($creditCardInformation);
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @uses \Pepitelabs\PWS\EstimatingService\PaymentType::valueIsValid()
     * @uses \Pepitelabs\PWS\EstimatingService\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \Pepitelabs\PWS\EstimatingService\PaymentInformation
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\EstimatingService\PaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\EstimatingService\PaymentType', is_array($paymentType) ? implode(', ', $paymentType) : var_export($paymentType, true), implode(', ', \Pepitelabs\PWS\EstimatingService\PaymentType::getValidValues())), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get RegisteredAccountNumber value
     * @return string|null
     */
    public function getRegisteredAccountNumber()
    {
        return $this->RegisteredAccountNumber;
    }
    /**
     * Set RegisteredAccountNumber value
     * @param string $registeredAccountNumber
     * @return \Pepitelabs\PWS\EstimatingService\PaymentInformation
     */
    public function setRegisteredAccountNumber($registeredAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($registeredAccountNumber) && !is_string($registeredAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registeredAccountNumber, true), gettype($registeredAccountNumber)), __LINE__);
        }
        $this->RegisteredAccountNumber = $registeredAccountNumber;
        return $this;
    }
    /**
     * Get BillingAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return isset($this->BillingAccountNumber) ? $this->BillingAccountNumber : null;
    }
    /**
     * Set BillingAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billingAccountNumber
     * @return \Pepitelabs\PWS\EstimatingService\PaymentInformation
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        if (is_null($billingAccountNumber) || (is_array($billingAccountNumber) && empty($billingAccountNumber))) {
            unset($this->BillingAccountNumber);
        } else {
            $this->BillingAccountNumber = $billingAccountNumber;
        }
        return $this;
    }
    /**
     * Get CreditCardInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\CreditCardInformation|null
     */
    public function getCreditCardInformation()
    {
        return isset($this->CreditCardInformation) ? $this->CreditCardInformation : null;
    }
    /**
     * Set CreditCardInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\CreditCardInformation $creditCardInformation
     * @return \Pepitelabs\PWS\EstimatingService\PaymentInformation
     */
    public function setCreditCardInformation(\Pepitelabs\PWS\EstimatingService\CreditCardInformation $creditCardInformation = null)
    {
        if (is_null($creditCardInformation) || (is_array($creditCardInformation) && empty($creditCardInformation))) {
            unset($this->CreditCardInformation);
        } else {
            $this->CreditCardInformation = $creditCardInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\PaymentInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
