<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionsInformation EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: OptionsInformation
 * - nillable: true
 * - type: tns:OptionsInformation
 * @subpackage Structs
 */
class OptionsInformation extends AbstractStructBase
{
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - documentation: Options - OptionIDValuePair[]
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair
     */
    public $Options;
    /**
     * The ExpressChequeAddress
     * Meta information extracted from the WSDL
     * - documentation: ExpressChequeAddress - Address
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\Address
     */
    public $ExpressChequeAddress;
    /**
     * Constructor method for OptionsInformation
     * @uses OptionsInformation::setOptions()
     * @uses OptionsInformation::setExpressChequeAddress()
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair $options
     * @param \Pepitelabs\PWS\EstimatingService\Address $expressChequeAddress
     */
    public function __construct(\Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair $options = null, \Pepitelabs\PWS\EstimatingService\Address $expressChequeAddress = null)
    {
        $this
            ->setOptions($options)
            ->setExpressChequeAddress($expressChequeAddress);
    }
    /**
     * Get Options value
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair $options
     * @return \Pepitelabs\PWS\EstimatingService\OptionsInformation
     */
    public function setOptions(\Pepitelabs\PWS\EstimatingService\ArrayOfOptionIDValuePair $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get ExpressChequeAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\Address|null
     */
    public function getExpressChequeAddress()
    {
        return isset($this->ExpressChequeAddress) ? $this->ExpressChequeAddress : null;
    }
    /**
     * Set ExpressChequeAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\Address $expressChequeAddress
     * @return \Pepitelabs\PWS\EstimatingService\OptionsInformation
     */
    public function setExpressChequeAddress(\Pepitelabs\PWS\EstimatingService\Address $expressChequeAddress = null)
    {
        if (is_null($expressChequeAddress) || (is_array($expressChequeAddress) && empty($expressChequeAddress))) {
            unset($this->ExpressChequeAddress);
        } else {
            $this->ExpressChequeAddress = $expressChequeAddress;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\OptionsInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
