<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InternationalInformation EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: InternationalInformation
 * - nillable: true
 * - type: tns:InternationalInformation
 * @subpackage Structs
 */
class InternationalInformation extends AbstractStructBase
{
    /**
     * The DocumentsOnlyIndicator
     * Meta information extracted from the WSDL
     * - documentation: DocumentsOnlyIndicator - bool
     * @var bool
     */
    public $DocumentsOnlyIndicator;
    /**
     * The ContentDetails
     * Meta information extracted from the WSDL
     * - documentation: ContentDetails - ContentDetail[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfContentDetail
     */
    public $ContentDetails;
    /**
     * The BuyerInformation
     * Meta information extracted from the WSDL
     * - documentation: BuyerInformation - BuyerInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\BuyerInformation
     */
    public $BuyerInformation;
    /**
     * The PreferredCustomsBroker
     * Meta information extracted from the WSDL
     * - documentation: PreferredCustomsBroker - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredCustomsBroker;
    /**
     * The DutyInformation
     * Meta information extracted from the WSDL
     * - documentation: DutyInformation - DutyInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\DutyInformation
     */
    public $DutyInformation;
    /**
     * The ImportExportType
     * Meta information extracted from the WSDL
     * - documentation: ImportExportType - ImportExportType
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportExportType;
    /**
     * The CustomsInvoiceDocumentIndicator
     * Meta information extracted from the WSDL
     * - documentation: CustomsInvoiceDocumentIndicator - bool
     * - minOccurs: 0
     * @var bool
     */
    public $CustomsInvoiceDocumentIndicator;
    /**
     * Constructor method for InternationalInformation
     * @uses InternationalInformation::setDocumentsOnlyIndicator()
     * @uses InternationalInformation::setContentDetails()
     * @uses InternationalInformation::setBuyerInformation()
     * @uses InternationalInformation::setPreferredCustomsBroker()
     * @uses InternationalInformation::setDutyInformation()
     * @uses InternationalInformation::setImportExportType()
     * @uses InternationalInformation::setCustomsInvoiceDocumentIndicator()
     * @param bool $documentsOnlyIndicator
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfContentDetail $contentDetails
     * @param \Pepitelabs\PWS\EstimatingService\BuyerInformation $buyerInformation
     * @param string $preferredCustomsBroker
     * @param \Pepitelabs\PWS\EstimatingService\DutyInformation $dutyInformation
     * @param string $importExportType
     * @param bool $customsInvoiceDocumentIndicator
     */
    public function __construct($documentsOnlyIndicator = null, \Pepitelabs\PWS\EstimatingService\ArrayOfContentDetail $contentDetails = null, \Pepitelabs\PWS\EstimatingService\BuyerInformation $buyerInformation = null, $preferredCustomsBroker = null, \Pepitelabs\PWS\EstimatingService\DutyInformation $dutyInformation = null, $importExportType = null, $customsInvoiceDocumentIndicator = null)
    {
        $this
            ->setDocumentsOnlyIndicator($documentsOnlyIndicator)
            ->setContentDetails($contentDetails)
            ->setBuyerInformation($buyerInformation)
            ->setPreferredCustomsBroker($preferredCustomsBroker)
            ->setDutyInformation($dutyInformation)
            ->setImportExportType($importExportType)
            ->setCustomsInvoiceDocumentIndicator($customsInvoiceDocumentIndicator);
    }
    /**
     * Get DocumentsOnlyIndicator value
     * @return bool|null
     */
    public function getDocumentsOnlyIndicator()
    {
        return $this->DocumentsOnlyIndicator;
    }
    /**
     * Set DocumentsOnlyIndicator value
     * @param bool $documentsOnlyIndicator
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public function setDocumentsOnlyIndicator($documentsOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($documentsOnlyIndicator) && !is_bool($documentsOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($documentsOnlyIndicator, true), gettype($documentsOnlyIndicator)), __LINE__);
        }
        $this->DocumentsOnlyIndicator = $documentsOnlyIndicator;
        return $this;
    }
    /**
     * Get ContentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfContentDetail|null
     */
    public function getContentDetails()
    {
        return isset($this->ContentDetails) ? $this->ContentDetails : null;
    }
    /**
     * Set ContentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfContentDetail $contentDetails
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public function setContentDetails(\Pepitelabs\PWS\EstimatingService\ArrayOfContentDetail $contentDetails = null)
    {
        if (is_null($contentDetails) || (is_array($contentDetails) && empty($contentDetails))) {
            unset($this->ContentDetails);
        } else {
            $this->ContentDetails = $contentDetails;
        }
        return $this;
    }
    /**
     * Get BuyerInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\BuyerInformation|null
     */
    public function getBuyerInformation()
    {
        return isset($this->BuyerInformation) ? $this->BuyerInformation : null;
    }
    /**
     * Set BuyerInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\BuyerInformation $buyerInformation
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public function setBuyerInformation(\Pepitelabs\PWS\EstimatingService\BuyerInformation $buyerInformation = null)
    {
        if (is_null($buyerInformation) || (is_array($buyerInformation) && empty($buyerInformation))) {
            unset($this->BuyerInformation);
        } else {
            $this->BuyerInformation = $buyerInformation;
        }
        return $this;
    }
    /**
     * Get PreferredCustomsBroker value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredCustomsBroker()
    {
        return isset($this->PreferredCustomsBroker) ? $this->PreferredCustomsBroker : null;
    }
    /**
     * Set PreferredCustomsBroker value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredCustomsBroker
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public function setPreferredCustomsBroker($preferredCustomsBroker = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCustomsBroker) && !is_string($preferredCustomsBroker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredCustomsBroker, true), gettype($preferredCustomsBroker)), __LINE__);
        }
        if (is_null($preferredCustomsBroker) || (is_array($preferredCustomsBroker) && empty($preferredCustomsBroker))) {
            unset($this->PreferredCustomsBroker);
        } else {
            $this->PreferredCustomsBroker = $preferredCustomsBroker;
        }
        return $this;
    }
    /**
     * Get DutyInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\DutyInformation|null
     */
    public function getDutyInformation()
    {
        return isset($this->DutyInformation) ? $this->DutyInformation : null;
    }
    /**
     * Set DutyInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\DutyInformation $dutyInformation
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public function setDutyInformation(\Pepitelabs\PWS\EstimatingService\DutyInformation $dutyInformation = null)
    {
        if (is_null($dutyInformation) || (is_array($dutyInformation) && empty($dutyInformation))) {
            unset($this->DutyInformation);
        } else {
            $this->DutyInformation = $dutyInformation;
        }
        return $this;
    }
    /**
     * Get ImportExportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportExportType()
    {
        return isset($this->ImportExportType) ? $this->ImportExportType : null;
    }
    /**
     * Set ImportExportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pepitelabs\PWS\EstimatingService\ImportExportType::valueIsValid()
     * @uses \Pepitelabs\PWS\EstimatingService\ImportExportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importExportType
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public function setImportExportType($importExportType = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\EstimatingService\ImportExportType::valueIsValid($importExportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\EstimatingService\ImportExportType', is_array($importExportType) ? implode(', ', $importExportType) : var_export($importExportType, true), implode(', ', \Pepitelabs\PWS\EstimatingService\ImportExportType::getValidValues())), __LINE__);
        }
        if (is_null($importExportType) || (is_array($importExportType) && empty($importExportType))) {
            unset($this->ImportExportType);
        } else {
            $this->ImportExportType = $importExportType;
        }
        return $this;
    }
    /**
     * Get CustomsInvoiceDocumentIndicator value
     * @return bool|null
     */
    public function getCustomsInvoiceDocumentIndicator()
    {
        return $this->CustomsInvoiceDocumentIndicator;
    }
    /**
     * Set CustomsInvoiceDocumentIndicator value
     * @param bool $customsInvoiceDocumentIndicator
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public function setCustomsInvoiceDocumentIndicator($customsInvoiceDocumentIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsInvoiceDocumentIndicator) && !is_bool($customsInvoiceDocumentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customsInvoiceDocumentIndicator, true), gettype($customsInvoiceDocumentIndicator)), __LINE__);
        }
        $this->CustomsInvoiceDocumentIndicator = $customsInvoiceDocumentIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
