<?php

namespace Pepitelabs\PWS\EstimatingService;

/**
 * This class stands for ImportExportType EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: ImportExportType - enum
 * - nillable: true
 * - type: tns:ImportExportType
 * @subpackage Enumerations
 */
class ImportExportType
{
    /**
     * Constant for value 'Permanent'
     * Meta information extracted from the WSDL
     * - documentation: Permanent
     * @return string 'Permanent'
     */
    const VALUE_PERMANENT = 'Permanent';
    /**
     * Constant for value 'Temporary'
     * Meta information extracted from the WSDL
     * - documentation: Temporary
     * @return string 'Temporary'
     */
    const VALUE_TEMPORARY = 'Temporary';
    /**
     * Constant for value 'Repair'
     * Meta information extracted from the WSDL
     * - documentation: Repair
     * @return string 'Repair'
     */
    const VALUE_REPAIR = 'Repair';
    /**
     * Constant for value 'Return'
     * Meta information extracted from the WSDL
     * - documentation: Return
     * @return string 'Return'
     */
    const VALUE_RETURN = 'Return';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERMANENT
     * @uses self::VALUE_TEMPORARY
     * @uses self::VALUE_REPAIR
     * @uses self::VALUE_RETURN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERMANENT,
            self::VALUE_TEMPORARY,
            self::VALUE_REPAIR,
            self::VALUE_RETURN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
