<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQuickEstimateRequestContainer EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: GetQuickEstimateRequest
 * - nillable: true
 * - type: tns:GetQuickEstimateRequestContainer
 * @subpackage Structs
 */
class GetQuickEstimateRequestContainer extends RequestContainer
{
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: AccountNumber - string
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The SenderPostalCode
     * Meta information extracted from the WSDL
     * - documentation: SenderPostalCode - string
     * - nillable: true
     * @var string
     */
    public $SenderPostalCode;
    /**
     * The ReceiverAddress
     * Meta information extracted from the WSDL
     * - documentation: ReceiverAddress - ShortAddress
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ShortAddress
     */
    public $ReceiverAddress;
    /**
     * The PackageType
     * Meta information extracted from the WSDL
     * - documentation: PackageType - PackageType
     * - nillable: true
     * @var string
     */
    public $PackageType;
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - documentation: TotalWeight - Weight
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\TotalWeight
     */
    public $TotalWeight;
    /**
     * Constructor method for GetQuickEstimateRequestContainer
     * @uses GetQuickEstimateRequestContainer::setBillingAccountNumber()
     * @uses GetQuickEstimateRequestContainer::setSenderPostalCode()
     * @uses GetQuickEstimateRequestContainer::setReceiverAddress()
     * @uses GetQuickEstimateRequestContainer::setPackageType()
     * @uses GetQuickEstimateRequestContainer::setTotalWeight()
     * @param string $billingAccountNumber
     * @param string $senderPostalCode
     * @param \Pepitelabs\PWS\EstimatingService\ShortAddress $receiverAddress
     * @param string $packageType
     * @param \Pepitelabs\PWS\EstimatingService\TotalWeight $totalWeight
     */
    public function __construct($billingAccountNumber = null, $senderPostalCode = null, \Pepitelabs\PWS\EstimatingService\ShortAddress $receiverAddress = null, $packageType = null, \Pepitelabs\PWS\EstimatingService\TotalWeight $totalWeight = null)
    {
        $this
            ->setBillingAccountNumber($billingAccountNumber)
            ->setSenderPostalCode($senderPostalCode)
            ->setReceiverAddress($receiverAddress)
            ->setPackageType($packageType)
            ->setTotalWeight($totalWeight);
    }
    /**
     * Get BillingAccountNumber value
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return $this->BillingAccountNumber;
    }
    /**
     * Set BillingAccountNumber value
     * @param string $billingAccountNumber
     * @return \Pepitelabs\PWS\EstimatingService\GetQuickEstimateRequestContainer
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        $this->BillingAccountNumber = $billingAccountNumber;
        return $this;
    }
    /**
     * Get SenderPostalCode value
     * @return string|null
     */
    public function getSenderPostalCode()
    {
        return $this->SenderPostalCode;
    }
    /**
     * Set SenderPostalCode value
     * @param string $senderPostalCode
     * @return \Pepitelabs\PWS\EstimatingService\GetQuickEstimateRequestContainer
     */
    public function setSenderPostalCode($senderPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($senderPostalCode) && !is_string($senderPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderPostalCode, true), gettype($senderPostalCode)), __LINE__);
        }
        $this->SenderPostalCode = $senderPostalCode;
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * @return \Pepitelabs\PWS\EstimatingService\ShortAddress|null
     */
    public function getReceiverAddress()
    {
        return $this->ReceiverAddress;
    }
    /**
     * Set ReceiverAddress value
     * @param \Pepitelabs\PWS\EstimatingService\ShortAddress $receiverAddress
     * @return \Pepitelabs\PWS\EstimatingService\GetQuickEstimateRequestContainer
     */
    public function setReceiverAddress(\Pepitelabs\PWS\EstimatingService\ShortAddress $receiverAddress = null)
    {
        $this->ReceiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * Get PackageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->PackageType;
    }
    /**
     * Set PackageType value
     * @param string $packageType
     * @return \Pepitelabs\PWS\EstimatingService\GetQuickEstimateRequestContainer
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageType, true), gettype($packageType)), __LINE__);
        }
        $this->PackageType = $packageType;
        return $this;
    }
    /**
     * Get TotalWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\TotalWeight|null
     */
    public function getTotalWeight()
    {
        return isset($this->TotalWeight) ? $this->TotalWeight : null;
    }
    /**
     * Set TotalWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\TotalWeight $totalWeight
     * @return \Pepitelabs\PWS\EstimatingService\GetQuickEstimateRequestContainer
     */
    public function setTotalWeight(\Pepitelabs\PWS\EstimatingService\TotalWeight $totalWeight = null)
    {
        if (is_null($totalWeight) || (is_array($totalWeight) && empty($totalWeight))) {
            unset($this->TotalWeight);
        } else {
            $this->TotalWeight = $totalWeight;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\GetQuickEstimateRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
