<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFullEstimateResponseContainer EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: GetFullEstimateResponse
 * - nillable: true
 * - type: tns:GetFullEstimateResponseContainer
 * @subpackage Structs
 */
class GetFullEstimateResponseContainer extends ResponseContainer
{
    /**
     * The ShipmentEstimates
     * Meta information extracted from the WSDL
     * - documentation: ShipmentEstimates - ShipmentEstimate[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate
     */
    public $ShipmentEstimates;
    /**
     * The ReturnShipmentEstimates
     * Meta information extracted from the WSDL
     * - documentation: ReturnShipmentEstimates - ShipmentEstimate[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate
     */
    public $ReturnShipmentEstimates;
    /**
     * Constructor method for GetFullEstimateResponseContainer
     * @uses GetFullEstimateResponseContainer::setShipmentEstimates()
     * @uses GetFullEstimateResponseContainer::setReturnShipmentEstimates()
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate $shipmentEstimates
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate $returnShipmentEstimates
     */
    public function __construct(\Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate $shipmentEstimates = null, \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate $returnShipmentEstimates = null)
    {
        $this
            ->setShipmentEstimates($shipmentEstimates)
            ->setReturnShipmentEstimates($returnShipmentEstimates);
    }
    /**
     * Get ShipmentEstimates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate|null
     */
    public function getShipmentEstimates()
    {
        return isset($this->ShipmentEstimates) ? $this->ShipmentEstimates : null;
    }
    /**
     * Set ShipmentEstimates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate $shipmentEstimates
     * @return \Pepitelabs\PWS\EstimatingService\GetFullEstimateResponseContainer
     */
    public function setShipmentEstimates(\Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate $shipmentEstimates = null)
    {
        if (is_null($shipmentEstimates) || (is_array($shipmentEstimates) && empty($shipmentEstimates))) {
            unset($this->ShipmentEstimates);
        } else {
            $this->ShipmentEstimates = $shipmentEstimates;
        }
        return $this;
    }
    /**
     * Get ReturnShipmentEstimates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate|null
     */
    public function getReturnShipmentEstimates()
    {
        return isset($this->ReturnShipmentEstimates) ? $this->ReturnShipmentEstimates : null;
    }
    /**
     * Set ReturnShipmentEstimates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate $returnShipmentEstimates
     * @return \Pepitelabs\PWS\EstimatingService\GetFullEstimateResponseContainer
     */
    public function setReturnShipmentEstimates(\Pepitelabs\PWS\EstimatingService\ArrayOfShipmentEstimate $returnShipmentEstimates = null)
    {
        if (is_null($returnShipmentEstimates) || (is_array($returnShipmentEstimates) && empty($returnShipmentEstimates))) {
            unset($this->ReturnShipmentEstimates);
        } else {
            $this->ReturnShipmentEstimates = $returnShipmentEstimates;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\GetFullEstimateResponseContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
