<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFullEstimateRequestContainer EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: GetFullEstimateRequest
 * - nillable: true
 * - type: tns:GetFullEstimateRequestContainer
 * @subpackage Structs
 */
class GetFullEstimateRequestContainer extends RequestContainer
{
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - documentation: Shipment - Shipment
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public $Shipment;
    /**
     * The ShowAlternativeServicesIndicator
     * Meta information extracted from the WSDL
     * - documentation: ShowAlternativeServicesIndicator - boolean
     * @var bool
     */
    public $ShowAlternativeServicesIndicator;
    /**
     * Constructor method for GetFullEstimateRequestContainer
     * @uses GetFullEstimateRequestContainer::setShipment()
     * @uses GetFullEstimateRequestContainer::setShowAlternativeServicesIndicator()
     * @param \Pepitelabs\PWS\EstimatingService\Shipment $shipment
     * @param bool $showAlternativeServicesIndicator
     */
    public function __construct(\Pepitelabs\PWS\EstimatingService\Shipment $shipment = null, $showAlternativeServicesIndicator = null)
    {
        $this
            ->setShipment($shipment)
            ->setShowAlternativeServicesIndicator($showAlternativeServicesIndicator);
    }
    /**
     * Get Shipment value
     * @return \Pepitelabs\PWS\EstimatingService\Shipment|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Pepitelabs\PWS\EstimatingService\Shipment $shipment
     * @return \Pepitelabs\PWS\EstimatingService\GetFullEstimateRequestContainer
     */
    public function setShipment(\Pepitelabs\PWS\EstimatingService\Shipment $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get ShowAlternativeServicesIndicator value
     * @return bool|null
     */
    public function getShowAlternativeServicesIndicator()
    {
        return $this->ShowAlternativeServicesIndicator;
    }
    /**
     * Set ShowAlternativeServicesIndicator value
     * @param bool $showAlternativeServicesIndicator
     * @return \Pepitelabs\PWS\EstimatingService\GetFullEstimateRequestContainer
     */
    public function setShowAlternativeServicesIndicator($showAlternativeServicesIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAlternativeServicesIndicator) && !is_bool($showAlternativeServicesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAlternativeServicesIndicator, true), gettype($showAlternativeServicesIndicator)), __LINE__);
        }
        $this->ShowAlternativeServicesIndicator = $showAlternativeServicesIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\GetFullEstimateRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
