<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get EstimatingService
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\EstimatingService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\EstimatingService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetQuickEstimate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v2
     * - SOAPHeaderTypes: \Pepitelabs\PWS\EstimatingService\RequestContext
     * - SOAPHeaders: required
     * - documentation: GetQuickEstimate @param request GetQuickEstimateRequest @return GetQuickEstimateResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\EstimatingService\GetQuickEstimateRequestContainer $getQuickEstimateRequest
     * @return \Pepitelabs\PWS\EstimatingService\GetQuickEstimateResponseContainer|bool
     */
    public function GetQuickEstimate(\Pepitelabs\PWS\EstimatingService\GetQuickEstimateRequestContainer $getQuickEstimateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQuickEstimate($getQuickEstimateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFullEstimate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v2
     * - SOAPHeaderTypes: \Pepitelabs\PWS\EstimatingService\RequestContext
     * - SOAPHeaders: required
     * - documentation: GetFullEstimate @param request GetFullEstimateRequest @return GetFullEstimateResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\EstimatingService\GetFullEstimateRequestContainer $getFullEstimateRequest
     * @return \Pepitelabs\PWS\EstimatingService\GetFullEstimateResponseContainer|bool
     */
    public function GetFullEstimate(\Pepitelabs\PWS\EstimatingService\GetFullEstimateRequestContainer $getFullEstimateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFullEstimate($getFullEstimateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\EstimatingService\GetFullEstimateResponseContainer|\Pepitelabs\PWS\EstimatingService\GetQuickEstimateResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
