<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: Error
 * - nillable: true
 * - type: tns:Error
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Code - string
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description - string
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - documentation: AdditionalInformation - string
     * - nillable: true
     * @var string
     */
    public $AdditionalInformation;
    /**
     * Constructor method for Error
     * @uses Error::setCode()
     * @uses Error::setDescription()
     * @uses Error::setAdditionalInformation()
     * @param string $code
     * @param string $description
     * @param string $additionalInformation
     */
    public function __construct($code = null, $description = null, $additionalInformation = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setAdditionalInformation($additionalInformation);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Pepitelabs\PWS\EstimatingService\Error
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Pepitelabs\PWS\EstimatingService\Error
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return string|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param string $additionalInformation
     * @return \Pepitelabs\PWS\EstimatingService\Error
     */
    public function setAdditionalInformation($additionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformation) && !is_string($additionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInformation, true), gettype($additionalInformation)), __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
