<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DutyInformation EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: DutyInformation
 * - nillable: true
 * - type: tns:DutyInformation
 * @subpackage Structs
 */
class DutyInformation extends AbstractStructBase
{
    /**
     * The BillDutiesToParty
     * Meta information extracted from the WSDL
     * - documentation: BillDutiesToParty - BillDutiesToParty
     * - nillable: true
     * @var string
     */
    public $BillDutiesToParty;
    /**
     * The BusinessRelationship
     * Meta information extracted from the WSDL
     * - documentation: BusinessRelationship - BusinessRelationship
     * - nillable: true
     * @var string
     */
    public $BusinessRelationship;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - documentation: Currency - DutyCurrency
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for DutyInformation
     * @uses DutyInformation::setBillDutiesToParty()
     * @uses DutyInformation::setBusinessRelationship()
     * @uses DutyInformation::setCurrency()
     * @param string $billDutiesToParty
     * @param string $businessRelationship
     * @param string $currency
     */
    public function __construct($billDutiesToParty = null, $businessRelationship = null, $currency = null)
    {
        $this
            ->setBillDutiesToParty($billDutiesToParty)
            ->setBusinessRelationship($businessRelationship)
            ->setCurrency($currency);
    }
    /**
     * Get BillDutiesToParty value
     * @return string|null
     */
    public function getBillDutiesToParty()
    {
        return $this->BillDutiesToParty;
    }
    /**
     * Set BillDutiesToParty value
     * @uses \Pepitelabs\PWS\EstimatingService\BillDutiesToParty::valueIsValid()
     * @uses \Pepitelabs\PWS\EstimatingService\BillDutiesToParty::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billDutiesToParty
     * @return \Pepitelabs\PWS\EstimatingService\DutyInformation
     */
    public function setBillDutiesToParty($billDutiesToParty = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\EstimatingService\BillDutiesToParty::valueIsValid($billDutiesToParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\EstimatingService\BillDutiesToParty', is_array($billDutiesToParty) ? implode(', ', $billDutiesToParty) : var_export($billDutiesToParty, true), implode(', ', \Pepitelabs\PWS\EstimatingService\BillDutiesToParty::getValidValues())), __LINE__);
        }
        $this->BillDutiesToParty = $billDutiesToParty;
        return $this;
    }
    /**
     * Get BusinessRelationship value
     * @return string|null
     */
    public function getBusinessRelationship()
    {
        return $this->BusinessRelationship;
    }
    /**
     * Set BusinessRelationship value
     * @uses \Pepitelabs\PWS\EstimatingService\BusinessRelationship::valueIsValid()
     * @uses \Pepitelabs\PWS\EstimatingService\BusinessRelationship::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessRelationship
     * @return \Pepitelabs\PWS\EstimatingService\DutyInformation
     */
    public function setBusinessRelationship($businessRelationship = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\EstimatingService\BusinessRelationship::valueIsValid($businessRelationship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\EstimatingService\BusinessRelationship', is_array($businessRelationship) ? implode(', ', $businessRelationship) : var_export($businessRelationship, true), implode(', ', \Pepitelabs\PWS\EstimatingService\BusinessRelationship::getValidValues())), __LINE__);
        }
        $this->BusinessRelationship = $businessRelationship;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \Pepitelabs\PWS\EstimatingService\DutyCurrency::valueIsValid()
     * @uses \Pepitelabs\PWS\EstimatingService\DutyCurrency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \Pepitelabs\PWS\EstimatingService\DutyInformation
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\EstimatingService\DutyCurrency::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\EstimatingService\DutyCurrency', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \Pepitelabs\PWS\EstimatingService\DutyCurrency::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\DutyInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
