<?php

namespace Pepitelabs\PWS\EstimatingService;

/**
 * This class stands for DimensionUnit EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: DimensionUnit - enum
 * - nillable: true
 * - type: tns:DimensionUnit
 * @subpackage Enumerations
 */
class DimensionUnit
{
    /**
     * Constant for value 'in'
     * Meta information extracted from the WSDL
     * - documentation: in
     * @return string 'in'
     */
    const VALUE_IN = 'in';
    /**
     * Constant for value 'cm'
     * Meta information extracted from the WSDL
     * - documentation: cm
     * @return string 'cm'
     */
    const VALUE_CM = 'cm';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IN
     * @uses self::VALUE_CM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IN,
            self::VALUE_CM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
