<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimension EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: Dimension
 * - nillable: true
 * - type: tns:Dimension
 * @subpackage Structs
 */
class Dimension extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Value - decimal
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The DimensionUnit
     * Meta information extracted from the WSDL
     * - documentation: DimensionUnit - DimensionUnit
     * @var string
     */
    public $DimensionUnit;
    /**
     * Constructor method for Dimension
     * @uses Dimension::setValue()
     * @uses Dimension::setDimensionUnit()
     * @param float $value
     * @param string $dimensionUnit
     */
    public function __construct($value = null, $dimensionUnit = null)
    {
        $this
            ->setValue($value)
            ->setDimensionUnit($dimensionUnit);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \Pepitelabs\PWS\EstimatingService\Dimension
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get DimensionUnit value
     * @return string|null
     */
    public function getDimensionUnit()
    {
        return $this->DimensionUnit;
    }
    /**
     * Set DimensionUnit value
     * @uses \Pepitelabs\PWS\EstimatingService\DimensionUnit::valueIsValid()
     * @uses \Pepitelabs\PWS\EstimatingService\DimensionUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dimensionUnit
     * @return \Pepitelabs\PWS\EstimatingService\Dimension
     */
    public function setDimensionUnit($dimensionUnit = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\EstimatingService\DimensionUnit::valueIsValid($dimensionUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\EstimatingService\DimensionUnit', is_array($dimensionUnit) ? implode(', ', $dimensionUnit) : var_export($dimensionUnit, true), implode(', ', \Pepitelabs\PWS\EstimatingService\DimensionUnit::getValidValues())), __LINE__);
        }
        $this->DimensionUnit = $dimensionUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\Dimension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
