<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTax EstimatingService
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTax
 * @subpackage Arrays
 */
class ArrayOfTax extends AbstractStructArrayBase
{
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\Tax[]
     */
    public $Tax;
    /**
     * Constructor method for ArrayOfTax
     * @uses ArrayOfTax::setTax()
     * @param \Pepitelabs\PWS\EstimatingService\Tax[] $tax
     */
    public function __construct(array $tax = array())
    {
        $this
            ->setTax($tax);
    }
    /**
     * Get Tax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\Tax[]|null
     */
    public function getTax()
    {
        return isset($this->Tax) ? $this->Tax : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTaxTaxItem) {
            // validation for constraint: itemType
            if (!$arrayOfTaxTaxItem instanceof \Pepitelabs\PWS\EstimatingService\Tax) {
                $invalidValues[] = is_object($arrayOfTaxTaxItem) ? get_class($arrayOfTaxTaxItem) : sprintf('%s(%s)', gettype($arrayOfTaxTaxItem), var_export($arrayOfTaxTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \Pepitelabs\PWS\EstimatingService\Tax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pepitelabs\PWS\EstimatingService\Tax[] $tax
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfTax
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        if (is_null($tax) || (is_array($tax) && empty($tax))) {
            unset($this->Tax);
        } else {
            $this->Tax = $tax;
        }
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Pepitelabs\PWS\EstimatingService\Tax $item
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfTax
     */
    public function addToTax(\Pepitelabs\PWS\EstimatingService\Tax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pepitelabs\PWS\EstimatingService\Tax) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \Pepitelabs\PWS\EstimatingService\Tax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pepitelabs\PWS\EstimatingService\Tax|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pepitelabs\PWS\EstimatingService\Tax|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pepitelabs\PWS\EstimatingService\Tax|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pepitelabs\PWS\EstimatingService\Tax|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pepitelabs\PWS\EstimatingService\Tax|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Tax
     */
    public function getAttributeName()
    {
        return 'Tax';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfTax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
