<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO302000ShipmentSummary StructType
 * @subpackage Structs
 */
class SO302000ShipmentSummary extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ShipmentNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentNbr;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Type;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Status;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Hold;
    /**
     * The Operation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Operation;
    /**
     * The ShipmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentDate;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Customer;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $WarehouseID;
    /**
     * The ToWarehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ToWarehouse;
    /**
     * The Workgroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Workgroup;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Owner;
    /**
     * The ShippedQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedQuantity;
    /**
     * The ControlQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ControlQuantity;
    /**
     * The ShippedWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedWeight;
    /**
     * The ShippedVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedVolume;
    /**
     * The Packages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Packages;
    /**
     * The PackageWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PackageWeight;
    /**
     * The NoteText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SO302000ShipmentSummaryServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SO302000ShipmentSummary
     * @uses SO302000ShipmentSummary::setDisplayName()
     * @uses SO302000ShipmentSummary::setShipmentNbr()
     * @uses SO302000ShipmentSummary::setType()
     * @uses SO302000ShipmentSummary::setStatus()
     * @uses SO302000ShipmentSummary::setHold()
     * @uses SO302000ShipmentSummary::setOperation()
     * @uses SO302000ShipmentSummary::setShipmentDate()
     * @uses SO302000ShipmentSummary::setCustomer()
     * @uses SO302000ShipmentSummary::setLocation()
     * @uses SO302000ShipmentSummary::setWarehouseID()
     * @uses SO302000ShipmentSummary::setToWarehouse()
     * @uses SO302000ShipmentSummary::setWorkgroup()
     * @uses SO302000ShipmentSummary::setOwner()
     * @uses SO302000ShipmentSummary::setShippedQuantity()
     * @uses SO302000ShipmentSummary::setControlQuantity()
     * @uses SO302000ShipmentSummary::setShippedWeight()
     * @uses SO302000ShipmentSummary::setShippedVolume()
     * @uses SO302000ShipmentSummary::setPackages()
     * @uses SO302000ShipmentSummary::setPackageWeight()
     * @uses SO302000ShipmentSummary::setNoteText()
     * @uses SO302000ShipmentSummary::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $shipmentNbr
     * @param \StructType\Field $type
     * @param \StructType\Field $status
     * @param \StructType\Field $hold
     * @param \StructType\Field $operation
     * @param \StructType\Field $shipmentDate
     * @param \StructType\Field $customer
     * @param \StructType\Field $location
     * @param \StructType\Field $warehouseID
     * @param \StructType\Field $toWarehouse
     * @param \StructType\Field $workgroup
     * @param \StructType\Field $owner
     * @param \StructType\Field $shippedQuantity
     * @param \StructType\Field $controlQuantity
     * @param \StructType\Field $shippedWeight
     * @param \StructType\Field $shippedVolume
     * @param \StructType\Field $packages
     * @param \StructType\Field $packageWeight
     * @param \StructType\Field $noteText
     * @param \StructType\SO302000ShipmentSummaryServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $shipmentNbr = null, \StructType\Field $type = null, \StructType\Field $status = null, \StructType\Field $hold = null, \StructType\Field $operation = null, \StructType\Field $shipmentDate = null, \StructType\Field $customer = null, \StructType\Field $location = null, \StructType\Field $warehouseID = null, \StructType\Field $toWarehouse = null, \StructType\Field $workgroup = null, \StructType\Field $owner = null, \StructType\Field $shippedQuantity = null, \StructType\Field $controlQuantity = null, \StructType\Field $shippedWeight = null, \StructType\Field $shippedVolume = null, \StructType\Field $packages = null, \StructType\Field $packageWeight = null, \StructType\Field $noteText = null, \StructType\SO302000ShipmentSummaryServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setShipmentNbr($shipmentNbr)
            ->setType($type)
            ->setStatus($status)
            ->setHold($hold)
            ->setOperation($operation)
            ->setShipmentDate($shipmentDate)
            ->setCustomer($customer)
            ->setLocation($location)
            ->setWarehouseID($warehouseID)
            ->setToWarehouse($toWarehouse)
            ->setWorkgroup($workgroup)
            ->setOwner($owner)
            ->setShippedQuantity($shippedQuantity)
            ->setControlQuantity($controlQuantity)
            ->setShippedWeight($shippedWeight)
            ->setShippedVolume($shippedVolume)
            ->setPackages($packages)
            ->setPackageWeight($packageWeight)
            ->setNoteText($noteText)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * @return \StructType\Field|null
     */
    public function getShipmentNbr()
    {
        return $this->ShipmentNbr;
    }
    /**
     * Set ShipmentNbr value
     * @param \StructType\Field $shipmentNbr
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setShipmentNbr(\StructType\Field $shipmentNbr = null)
    {
        $this->ShipmentNbr = $shipmentNbr;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\Field|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\Field $type
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setType(\StructType\Field $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Field|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Field $status
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setStatus(\StructType\Field $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Hold value
     * @return \StructType\Field|null
     */
    public function getHold()
    {
        return $this->Hold;
    }
    /**
     * Set Hold value
     * @param \StructType\Field $hold
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setHold(\StructType\Field $hold = null)
    {
        $this->Hold = $hold;
        return $this;
    }
    /**
     * Get Operation value
     * @return \StructType\Field|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param \StructType\Field $operation
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setOperation(\StructType\Field $operation = null)
    {
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return \StructType\Field|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param \StructType\Field $shipmentDate
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setShipmentDate(\StructType\Field $shipmentDate = null)
    {
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\Field|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\Field $customer
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setCustomer(\StructType\Field $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return \StructType\Field|null
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param \StructType\Field $warehouseID
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setWarehouseID(\StructType\Field $warehouseID = null)
    {
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get ToWarehouse value
     * @return \StructType\Field|null
     */
    public function getToWarehouse()
    {
        return $this->ToWarehouse;
    }
    /**
     * Set ToWarehouse value
     * @param \StructType\Field $toWarehouse
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setToWarehouse(\StructType\Field $toWarehouse = null)
    {
        $this->ToWarehouse = $toWarehouse;
        return $this;
    }
    /**
     * Get Workgroup value
     * @return \StructType\Field|null
     */
    public function getWorkgroup()
    {
        return $this->Workgroup;
    }
    /**
     * Set Workgroup value
     * @param \StructType\Field $workgroup
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setWorkgroup(\StructType\Field $workgroup = null)
    {
        $this->Workgroup = $workgroup;
        return $this;
    }
    /**
     * Get Owner value
     * @return \StructType\Field|null
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * Set Owner value
     * @param \StructType\Field $owner
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setOwner(\StructType\Field $owner = null)
    {
        $this->Owner = $owner;
        return $this;
    }
    /**
     * Get ShippedQuantity value
     * @return \StructType\Field|null
     */
    public function getShippedQuantity()
    {
        return $this->ShippedQuantity;
    }
    /**
     * Set ShippedQuantity value
     * @param \StructType\Field $shippedQuantity
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setShippedQuantity(\StructType\Field $shippedQuantity = null)
    {
        $this->ShippedQuantity = $shippedQuantity;
        return $this;
    }
    /**
     * Get ControlQuantity value
     * @return \StructType\Field|null
     */
    public function getControlQuantity()
    {
        return $this->ControlQuantity;
    }
    /**
     * Set ControlQuantity value
     * @param \StructType\Field $controlQuantity
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setControlQuantity(\StructType\Field $controlQuantity = null)
    {
        $this->ControlQuantity = $controlQuantity;
        return $this;
    }
    /**
     * Get ShippedWeight value
     * @return \StructType\Field|null
     */
    public function getShippedWeight()
    {
        return $this->ShippedWeight;
    }
    /**
     * Set ShippedWeight value
     * @param \StructType\Field $shippedWeight
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setShippedWeight(\StructType\Field $shippedWeight = null)
    {
        $this->ShippedWeight = $shippedWeight;
        return $this;
    }
    /**
     * Get ShippedVolume value
     * @return \StructType\Field|null
     */
    public function getShippedVolume()
    {
        return $this->ShippedVolume;
    }
    /**
     * Set ShippedVolume value
     * @param \StructType\Field $shippedVolume
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setShippedVolume(\StructType\Field $shippedVolume = null)
    {
        $this->ShippedVolume = $shippedVolume;
        return $this;
    }
    /**
     * Get Packages value
     * @return \StructType\Field|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @param \StructType\Field $packages
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setPackages(\StructType\Field $packages = null)
    {
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Get PackageWeight value
     * @return \StructType\Field|null
     */
    public function getPackageWeight()
    {
        return $this->PackageWeight;
    }
    /**
     * Set PackageWeight value
     * @param \StructType\Field $packageWeight
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setPackageWeight(\StructType\Field $packageWeight = null)
    {
        $this->PackageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SO302000ShipmentSummaryServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SO302000ShipmentSummaryServiceCommands $serviceCommands
     * @return \StructType\SO302000ShipmentSummary
     */
    public function setServiceCommands(\StructType\SO302000ShipmentSummaryServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO302000ShipmentSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
