<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO302000Orders StructType
 * @subpackage Structs
 */
class SO302000Orders extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ShipmentNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentNbr;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The ShippedQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedQty;
    /**
     * The ShippedWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedWeight;
    /**
     * The ShippedVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedVolume;
    /**
     * The InvoiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InvoiceType;
    /**
     * The InvoiceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InvoiceNbr;
    /**
     * The InventoryDocType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryDocType;
    /**
     * The InventoryRefNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryRefNbr;
    /**
     * The NoteText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SO302000OrdersServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SO302000Orders
     * @uses SO302000Orders::setDisplayName()
     * @uses SO302000Orders::setShipmentNbr()
     * @uses SO302000Orders::setOrderType()
     * @uses SO302000Orders::setOrderNbr()
     * @uses SO302000Orders::setShippedQty()
     * @uses SO302000Orders::setShippedWeight()
     * @uses SO302000Orders::setShippedVolume()
     * @uses SO302000Orders::setInvoiceType()
     * @uses SO302000Orders::setInvoiceNbr()
     * @uses SO302000Orders::setInventoryDocType()
     * @uses SO302000Orders::setInventoryRefNbr()
     * @uses SO302000Orders::setNoteText()
     * @uses SO302000Orders::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $shipmentNbr
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\Field $shippedQty
     * @param \StructType\Field $shippedWeight
     * @param \StructType\Field $shippedVolume
     * @param \StructType\Field $invoiceType
     * @param \StructType\Field $invoiceNbr
     * @param \StructType\Field $inventoryDocType
     * @param \StructType\Field $inventoryRefNbr
     * @param \StructType\Field $noteText
     * @param \StructType\SO302000OrdersServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $shipmentNbr = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\Field $shippedQty = null, \StructType\Field $shippedWeight = null, \StructType\Field $shippedVolume = null, \StructType\Field $invoiceType = null, \StructType\Field $invoiceNbr = null, \StructType\Field $inventoryDocType = null, \StructType\Field $inventoryRefNbr = null, \StructType\Field $noteText = null, \StructType\SO302000OrdersServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setShipmentNbr($shipmentNbr)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setShippedQty($shippedQty)
            ->setShippedWeight($shippedWeight)
            ->setShippedVolume($shippedVolume)
            ->setInvoiceType($invoiceType)
            ->setInvoiceNbr($invoiceNbr)
            ->setInventoryDocType($inventoryDocType)
            ->setInventoryRefNbr($inventoryRefNbr)
            ->setNoteText($noteText)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SO302000Orders
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * @return \StructType\Field|null
     */
    public function getShipmentNbr()
    {
        return $this->ShipmentNbr;
    }
    /**
     * Set ShipmentNbr value
     * @param \StructType\Field $shipmentNbr
     * @return \StructType\SO302000Orders
     */
    public function setShipmentNbr(\StructType\Field $shipmentNbr = null)
    {
        $this->ShipmentNbr = $shipmentNbr;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\SO302000Orders
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\SO302000Orders
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get ShippedQty value
     * @return \StructType\Field|null
     */
    public function getShippedQty()
    {
        return $this->ShippedQty;
    }
    /**
     * Set ShippedQty value
     * @param \StructType\Field $shippedQty
     * @return \StructType\SO302000Orders
     */
    public function setShippedQty(\StructType\Field $shippedQty = null)
    {
        $this->ShippedQty = $shippedQty;
        return $this;
    }
    /**
     * Get ShippedWeight value
     * @return \StructType\Field|null
     */
    public function getShippedWeight()
    {
        return $this->ShippedWeight;
    }
    /**
     * Set ShippedWeight value
     * @param \StructType\Field $shippedWeight
     * @return \StructType\SO302000Orders
     */
    public function setShippedWeight(\StructType\Field $shippedWeight = null)
    {
        $this->ShippedWeight = $shippedWeight;
        return $this;
    }
    /**
     * Get ShippedVolume value
     * @return \StructType\Field|null
     */
    public function getShippedVolume()
    {
        return $this->ShippedVolume;
    }
    /**
     * Set ShippedVolume value
     * @param \StructType\Field $shippedVolume
     * @return \StructType\SO302000Orders
     */
    public function setShippedVolume(\StructType\Field $shippedVolume = null)
    {
        $this->ShippedVolume = $shippedVolume;
        return $this;
    }
    /**
     * Get InvoiceType value
     * @return \StructType\Field|null
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }
    /**
     * Set InvoiceType value
     * @param \StructType\Field $invoiceType
     * @return \StructType\SO302000Orders
     */
    public function setInvoiceType(\StructType\Field $invoiceType = null)
    {
        $this->InvoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get InvoiceNbr value
     * @return \StructType\Field|null
     */
    public function getInvoiceNbr()
    {
        return $this->InvoiceNbr;
    }
    /**
     * Set InvoiceNbr value
     * @param \StructType\Field $invoiceNbr
     * @return \StructType\SO302000Orders
     */
    public function setInvoiceNbr(\StructType\Field $invoiceNbr = null)
    {
        $this->InvoiceNbr = $invoiceNbr;
        return $this;
    }
    /**
     * Get InventoryDocType value
     * @return \StructType\Field|null
     */
    public function getInventoryDocType()
    {
        return $this->InventoryDocType;
    }
    /**
     * Set InventoryDocType value
     * @param \StructType\Field $inventoryDocType
     * @return \StructType\SO302000Orders
     */
    public function setInventoryDocType(\StructType\Field $inventoryDocType = null)
    {
        $this->InventoryDocType = $inventoryDocType;
        return $this;
    }
    /**
     * Get InventoryRefNbr value
     * @return \StructType\Field|null
     */
    public function getInventoryRefNbr()
    {
        return $this->InventoryRefNbr;
    }
    /**
     * Set InventoryRefNbr value
     * @param \StructType\Field $inventoryRefNbr
     * @return \StructType\SO302000Orders
     */
    public function setInventoryRefNbr(\StructType\Field $inventoryRefNbr = null)
    {
        $this->InventoryRefNbr = $inventoryRefNbr;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\SO302000Orders
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SO302000OrdersServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SO302000OrdersServiceCommands $serviceCommands
     * @return \StructType\SO302000Orders
     */
    public function setServiceCommands(\StructType\SO302000OrdersServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO302000Orders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
