<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO302000DocumentDetails StructType
 * @subpackage Structs
 */
class SO302000DocumentDetails extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ShipmentNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentNbr;
    /**
     * The LineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineNbr;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The OrderLineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderLineNbr;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The FreeItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FreeItem;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Warehouse;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The ShippedQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedQty;
    /**
     * The OriginalQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OriginalQty;
    /**
     * The OrderedQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderedQty;
    /**
     * The OpenQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OpenQty;
    /**
     * The UndershipThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UndershipThreshold;
    /**
     * The ShippingRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippingRule;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReasonCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The NoteText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Availability;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SO302000DocumentDetailsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SO302000DocumentDetails
     * @uses SO302000DocumentDetails::setDisplayName()
     * @uses SO302000DocumentDetails::setShipmentNbr()
     * @uses SO302000DocumentDetails::setLineNbr()
     * @uses SO302000DocumentDetails::setOrderType()
     * @uses SO302000DocumentDetails::setOrderNbr()
     * @uses SO302000DocumentDetails::setOrderLineNbr()
     * @uses SO302000DocumentDetails::setInventoryID()
     * @uses SO302000DocumentDetails::setFreeItem()
     * @uses SO302000DocumentDetails::setWarehouse()
     * @uses SO302000DocumentDetails::setLocation()
     * @uses SO302000DocumentDetails::setUOM()
     * @uses SO302000DocumentDetails::setShippedQty()
     * @uses SO302000DocumentDetails::setOriginalQty()
     * @uses SO302000DocumentDetails::setOrderedQty()
     * @uses SO302000DocumentDetails::setOpenQty()
     * @uses SO302000DocumentDetails::setUndershipThreshold()
     * @uses SO302000DocumentDetails::setShippingRule()
     * @uses SO302000DocumentDetails::setReasonCode()
     * @uses SO302000DocumentDetails::setDescription()
     * @uses SO302000DocumentDetails::setNoteText()
     * @uses SO302000DocumentDetails::setAvailability()
     * @uses SO302000DocumentDetails::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $shipmentNbr
     * @param \StructType\Field $lineNbr
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\Field $orderLineNbr
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $freeItem
     * @param \StructType\Field $warehouse
     * @param \StructType\Field $location
     * @param \StructType\Field $uOM
     * @param \StructType\Field $shippedQty
     * @param \StructType\Field $originalQty
     * @param \StructType\Field $orderedQty
     * @param \StructType\Field $openQty
     * @param \StructType\Field $undershipThreshold
     * @param \StructType\Field $shippingRule
     * @param \StructType\Field $reasonCode
     * @param \StructType\Field $description
     * @param \StructType\Field $noteText
     * @param \StructType\Field $availability
     * @param \StructType\SO302000DocumentDetailsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $shipmentNbr = null, \StructType\Field $lineNbr = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\Field $orderLineNbr = null, \StructType\Field $inventoryID = null, \StructType\Field $freeItem = null, \StructType\Field $warehouse = null, \StructType\Field $location = null, \StructType\Field $uOM = null, \StructType\Field $shippedQty = null, \StructType\Field $originalQty = null, \StructType\Field $orderedQty = null, \StructType\Field $openQty = null, \StructType\Field $undershipThreshold = null, \StructType\Field $shippingRule = null, \StructType\Field $reasonCode = null, \StructType\Field $description = null, \StructType\Field $noteText = null, \StructType\Field $availability = null, \StructType\SO302000DocumentDetailsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setShipmentNbr($shipmentNbr)
            ->setLineNbr($lineNbr)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setOrderLineNbr($orderLineNbr)
            ->setInventoryID($inventoryID)
            ->setFreeItem($freeItem)
            ->setWarehouse($warehouse)
            ->setLocation($location)
            ->setUOM($uOM)
            ->setShippedQty($shippedQty)
            ->setOriginalQty($originalQty)
            ->setOrderedQty($orderedQty)
            ->setOpenQty($openQty)
            ->setUndershipThreshold($undershipThreshold)
            ->setShippingRule($shippingRule)
            ->setReasonCode($reasonCode)
            ->setDescription($description)
            ->setNoteText($noteText)
            ->setAvailability($availability)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SO302000DocumentDetails
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * @return \StructType\Field|null
     */
    public function getShipmentNbr()
    {
        return $this->ShipmentNbr;
    }
    /**
     * Set ShipmentNbr value
     * @param \StructType\Field $shipmentNbr
     * @return \StructType\SO302000DocumentDetails
     */
    public function setShipmentNbr(\StructType\Field $shipmentNbr = null)
    {
        $this->ShipmentNbr = $shipmentNbr;
        return $this;
    }
    /**
     * Get LineNbr value
     * @return \StructType\Field|null
     */
    public function getLineNbr()
    {
        return $this->LineNbr;
    }
    /**
     * Set LineNbr value
     * @param \StructType\Field $lineNbr
     * @return \StructType\SO302000DocumentDetails
     */
    public function setLineNbr(\StructType\Field $lineNbr = null)
    {
        $this->LineNbr = $lineNbr;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\SO302000DocumentDetails
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\SO302000DocumentDetails
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get OrderLineNbr value
     * @return \StructType\Field|null
     */
    public function getOrderLineNbr()
    {
        return $this->OrderLineNbr;
    }
    /**
     * Set OrderLineNbr value
     * @param \StructType\Field $orderLineNbr
     * @return \StructType\SO302000DocumentDetails
     */
    public function setOrderLineNbr(\StructType\Field $orderLineNbr = null)
    {
        $this->OrderLineNbr = $orderLineNbr;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\SO302000DocumentDetails
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get FreeItem value
     * @return \StructType\Field|null
     */
    public function getFreeItem()
    {
        return $this->FreeItem;
    }
    /**
     * Set FreeItem value
     * @param \StructType\Field $freeItem
     * @return \StructType\SO302000DocumentDetails
     */
    public function setFreeItem(\StructType\Field $freeItem = null)
    {
        $this->FreeItem = $freeItem;
        return $this;
    }
    /**
     * Get Warehouse value
     * @return \StructType\Field|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param \StructType\Field $warehouse
     * @return \StructType\SO302000DocumentDetails
     */
    public function setWarehouse(\StructType\Field $warehouse = null)
    {
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\SO302000DocumentDetails
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\SO302000DocumentDetails
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get ShippedQty value
     * @return \StructType\Field|null
     */
    public function getShippedQty()
    {
        return $this->ShippedQty;
    }
    /**
     * Set ShippedQty value
     * @param \StructType\Field $shippedQty
     * @return \StructType\SO302000DocumentDetails
     */
    public function setShippedQty(\StructType\Field $shippedQty = null)
    {
        $this->ShippedQty = $shippedQty;
        return $this;
    }
    /**
     * Get OriginalQty value
     * @return \StructType\Field|null
     */
    public function getOriginalQty()
    {
        return $this->OriginalQty;
    }
    /**
     * Set OriginalQty value
     * @param \StructType\Field $originalQty
     * @return \StructType\SO302000DocumentDetails
     */
    public function setOriginalQty(\StructType\Field $originalQty = null)
    {
        $this->OriginalQty = $originalQty;
        return $this;
    }
    /**
     * Get OrderedQty value
     * @return \StructType\Field|null
     */
    public function getOrderedQty()
    {
        return $this->OrderedQty;
    }
    /**
     * Set OrderedQty value
     * @param \StructType\Field $orderedQty
     * @return \StructType\SO302000DocumentDetails
     */
    public function setOrderedQty(\StructType\Field $orderedQty = null)
    {
        $this->OrderedQty = $orderedQty;
        return $this;
    }
    /**
     * Get OpenQty value
     * @return \StructType\Field|null
     */
    public function getOpenQty()
    {
        return $this->OpenQty;
    }
    /**
     * Set OpenQty value
     * @param \StructType\Field $openQty
     * @return \StructType\SO302000DocumentDetails
     */
    public function setOpenQty(\StructType\Field $openQty = null)
    {
        $this->OpenQty = $openQty;
        return $this;
    }
    /**
     * Get UndershipThreshold value
     * @return \StructType\Field|null
     */
    public function getUndershipThreshold()
    {
        return $this->UndershipThreshold;
    }
    /**
     * Set UndershipThreshold value
     * @param \StructType\Field $undershipThreshold
     * @return \StructType\SO302000DocumentDetails
     */
    public function setUndershipThreshold(\StructType\Field $undershipThreshold = null)
    {
        $this->UndershipThreshold = $undershipThreshold;
        return $this;
    }
    /**
     * Get ShippingRule value
     * @return \StructType\Field|null
     */
    public function getShippingRule()
    {
        return $this->ShippingRule;
    }
    /**
     * Set ShippingRule value
     * @param \StructType\Field $shippingRule
     * @return \StructType\SO302000DocumentDetails
     */
    public function setShippingRule(\StructType\Field $shippingRule = null)
    {
        $this->ShippingRule = $shippingRule;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return \StructType\Field|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param \StructType\Field $reasonCode
     * @return \StructType\SO302000DocumentDetails
     */
    public function setReasonCode(\StructType\Field $reasonCode = null)
    {
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\SO302000DocumentDetails
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\SO302000DocumentDetails
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get Availability value
     * @return \StructType\Field|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param \StructType\Field $availability
     * @return \StructType\SO302000DocumentDetails
     */
    public function setAvailability(\StructType\Field $availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SO302000DocumentDetailsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SO302000DocumentDetailsServiceCommands $serviceCommands
     * @return \StructType\SO302000DocumentDetails
     */
    public function setServiceCommands(\StructType\SO302000DocumentDetailsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO302000DocumentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
