<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IN202500ImportResult StructType
 * @subpackage Structs
 */
class IN202500ImportResult extends AbstractStructBase
{
    /**
     * The Processed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Processed;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * The Keys
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IN202500PrimaryKey
     */
    public $Keys;
    /**
     * Constructor method for IN202500ImportResult
     * @uses IN202500ImportResult::setProcessed()
     * @uses IN202500ImportResult::setError()
     * @uses IN202500ImportResult::setKeys()
     * @param bool $processed
     * @param string $error
     * @param \StructType\IN202500PrimaryKey $keys
     */
    public function __construct($processed = null, $error = null, \StructType\IN202500PrimaryKey $keys = null)
    {
        $this
            ->setProcessed($processed)
            ->setError($error)
            ->setKeys($keys);
    }
    /**
     * Get Processed value
     * @return bool
     */
    public function getProcessed()
    {
        return $this->Processed;
    }
    /**
     * Set Processed value
     * @param bool $processed
     * @return \StructType\IN202500ImportResult
     */
    public function setProcessed($processed = null)
    {
        $this->Processed = $processed;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\IN202500ImportResult
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get Keys value
     * @return \StructType\IN202500PrimaryKey|null
     */
    public function getKeys()
    {
        return $this->Keys;
    }
    /**
     * Set Keys value
     * @param \StructType\IN202500PrimaryKey $keys
     * @return \StructType\IN202500ImportResult
     */
    public function setKeys(\StructType\IN202500PrimaryKey $keys = null)
    {
        $this->Keys = $keys;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IN202500ImportResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
