<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AR303000ImportResult StructType
 * @subpackage Structs
 */
class AR303000ImportResult extends AbstractStructBase
{
    /**
     * The Processed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Processed;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * The Keys
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AR303000PrimaryKey
     */
    public $Keys;
    /**
     * Constructor method for AR303000ImportResult
     * @uses AR303000ImportResult::setProcessed()
     * @uses AR303000ImportResult::setError()
     * @uses AR303000ImportResult::setKeys()
     * @param bool $processed
     * @param string $error
     * @param \StructType\AR303000PrimaryKey $keys
     */
    public function __construct($processed = null, $error = null, \StructType\AR303000PrimaryKey $keys = null)
    {
        $this
            ->setProcessed($processed)
            ->setError($error)
            ->setKeys($keys);
    }
    /**
     * Get Processed value
     * @return bool
     */
    public function getProcessed()
    {
        return $this->Processed;
    }
    /**
     * Set Processed value
     * @param bool $processed
     * @return \StructType\AR303000ImportResult
     */
    public function setProcessed($processed = null)
    {
        $this->Processed = $processed;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\AR303000ImportResult
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get Keys value
     * @return \StructType\AR303000PrimaryKey|null
     */
    public function getKeys()
    {
        return $this->Keys;
    }
    /**
     * Set Keys value
     * @param \StructType\AR303000PrimaryKey $keys
     * @return \StructType\AR303000ImportResult
     */
    public function setKeys(\StructType\AR303000PrimaryKey $keys = null)
    {
        $this->Keys = $keys;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AR303000ImportResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
