<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AR303000CustomerSummaryBalance StructType
 * @subpackage Structs
 */
class AR303000CustomerSummaryBalance extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Balance;
    /**
     * The ConsolidatedBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ConsolidatedBalance;
    /**
     * The PrepaymentsBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrepaymentsBalance;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AR303000CustomerSummaryBalanceServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for AR303000CustomerSummaryBalance
     * @uses AR303000CustomerSummaryBalance::setDisplayName()
     * @uses AR303000CustomerSummaryBalance::setBalance()
     * @uses AR303000CustomerSummaryBalance::setConsolidatedBalance()
     * @uses AR303000CustomerSummaryBalance::setPrepaymentsBalance()
     * @uses AR303000CustomerSummaryBalance::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $balance
     * @param \StructType\Field $consolidatedBalance
     * @param \StructType\Field $prepaymentsBalance
     * @param \StructType\AR303000CustomerSummaryBalanceServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $balance = null, \StructType\Field $consolidatedBalance = null, \StructType\Field $prepaymentsBalance = null, \StructType\AR303000CustomerSummaryBalanceServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setBalance($balance)
            ->setConsolidatedBalance($consolidatedBalance)
            ->setPrepaymentsBalance($prepaymentsBalance)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\AR303000CustomerSummaryBalance
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Balance value
     * @return \StructType\Field|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param \StructType\Field $balance
     * @return \StructType\AR303000CustomerSummaryBalance
     */
    public function setBalance(\StructType\Field $balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get ConsolidatedBalance value
     * @return \StructType\Field|null
     */
    public function getConsolidatedBalance()
    {
        return $this->ConsolidatedBalance;
    }
    /**
     * Set ConsolidatedBalance value
     * @param \StructType\Field $consolidatedBalance
     * @return \StructType\AR303000CustomerSummaryBalance
     */
    public function setConsolidatedBalance(\StructType\Field $consolidatedBalance = null)
    {
        $this->ConsolidatedBalance = $consolidatedBalance;
        return $this;
    }
    /**
     * Get PrepaymentsBalance value
     * @return \StructType\Field|null
     */
    public function getPrepaymentsBalance()
    {
        return $this->PrepaymentsBalance;
    }
    /**
     * Set PrepaymentsBalance value
     * @param \StructType\Field $prepaymentsBalance
     * @return \StructType\AR303000CustomerSummaryBalance
     */
    public function setPrepaymentsBalance(\StructType\Field $prepaymentsBalance = null)
    {
        $this->PrepaymentsBalance = $prepaymentsBalance;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AR303000CustomerSummaryBalanceServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AR303000CustomerSummaryBalanceServiceCommands $serviceCommands
     * @return \StructType\AR303000CustomerSummaryBalance
     */
    public function setServiceCommands(\StructType\AR303000CustomerSummaryBalanceServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AR303000CustomerSummaryBalance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
