<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AR303000BillingSettingsParentInfo StructType
 * @subpackage Structs
 */
class AR303000BillingSettingsParentInfo extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ParentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ParentAccount;
    /**
     * The ConsolidateBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ConsolidateBalance;
    /**
     * The ConsolidateStatements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ConsolidateStatements;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AR303000BillingSettingsParentInfoServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for AR303000BillingSettingsParentInfo
     * @uses AR303000BillingSettingsParentInfo::setDisplayName()
     * @uses AR303000BillingSettingsParentInfo::setParentAccount()
     * @uses AR303000BillingSettingsParentInfo::setConsolidateBalance()
     * @uses AR303000BillingSettingsParentInfo::setConsolidateStatements()
     * @uses AR303000BillingSettingsParentInfo::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $parentAccount
     * @param \StructType\Field $consolidateBalance
     * @param \StructType\Field $consolidateStatements
     * @param \StructType\AR303000BillingSettingsParentInfoServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $parentAccount = null, \StructType\Field $consolidateBalance = null, \StructType\Field $consolidateStatements = null, \StructType\AR303000BillingSettingsParentInfoServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setParentAccount($parentAccount)
            ->setConsolidateBalance($consolidateBalance)
            ->setConsolidateStatements($consolidateStatements)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\AR303000BillingSettingsParentInfo
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ParentAccount value
     * @return \StructType\Field|null
     */
    public function getParentAccount()
    {
        return $this->ParentAccount;
    }
    /**
     * Set ParentAccount value
     * @param \StructType\Field $parentAccount
     * @return \StructType\AR303000BillingSettingsParentInfo
     */
    public function setParentAccount(\StructType\Field $parentAccount = null)
    {
        $this->ParentAccount = $parentAccount;
        return $this;
    }
    /**
     * Get ConsolidateBalance value
     * @return \StructType\Field|null
     */
    public function getConsolidateBalance()
    {
        return $this->ConsolidateBalance;
    }
    /**
     * Set ConsolidateBalance value
     * @param \StructType\Field $consolidateBalance
     * @return \StructType\AR303000BillingSettingsParentInfo
     */
    public function setConsolidateBalance(\StructType\Field $consolidateBalance = null)
    {
        $this->ConsolidateBalance = $consolidateBalance;
        return $this;
    }
    /**
     * Get ConsolidateStatements value
     * @return \StructType\Field|null
     */
    public function getConsolidateStatements()
    {
        return $this->ConsolidateStatements;
    }
    /**
     * Set ConsolidateStatements value
     * @param \StructType\Field $consolidateStatements
     * @return \StructType\AR303000BillingSettingsParentInfo
     */
    public function setConsolidateStatements(\StructType\Field $consolidateStatements = null)
    {
        $this->ConsolidateStatements = $consolidateStatements;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AR303000BillingSettingsParentInfoServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AR303000BillingSettingsParentInfoServiceCommands $serviceCommands
     * @return \StructType\AR303000BillingSettingsParentInfo
     */
    public function setServiceCommands(\StructType\AR303000BillingSettingsParentInfoServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AR303000BillingSettingsParentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
