<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOS ServiceType
 * @subpackage Services
 */
class SOS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO301000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO301000SetSchema $parameters
     * @return \StructType\SO301000SetSchemaResponse|bool
     */
    public function SO301000SetSchema(\StructType\SO301000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO301000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO301000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO301000Submit $parameters
     * @return \StructType\SO301000SubmitResponse|bool
     */
    public function SO301000Submit(\StructType\SO301000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO301000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO302000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO302000SetSchema $parameters
     * @return \StructType\SO302000SetSchemaResponse|bool
     */
    public function SO302000SetSchema(\StructType\SO302000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO302000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO302000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO302000Submit $parameters
     * @return \StructType\SO302000SubmitResponse|bool
     */
    public function SO302000Submit(\StructType\SO302000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO302000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO301000SetSchemaResponse|\StructType\SO301000SubmitResponse|\StructType\SO302000SetSchemaResponse|\StructType\SO302000SubmitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
