<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOG ServiceType
 * @subpackage Services
 */
class SOG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO301000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO301000GetProcessStatus $parameters
     * @return \StructType\SO301000GetProcessStatusResponse|bool
     */
    public function SO301000GetProcessStatus(\StructType\SO301000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO301000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO301000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO301000GetSchema $parameters
     * @return \StructType\SO301000GetSchemaResponse|bool
     */
    public function SO301000GetSchema(\StructType\SO301000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO301000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO302000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO302000GetProcessStatus $parameters
     * @return \StructType\SO302000GetProcessStatusResponse|bool
     */
    public function SO302000GetProcessStatus(\StructType\SO302000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO302000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO302000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO302000GetSchema $parameters
     * @return \StructType\SO302000GetSchemaResponse|bool
     */
    public function SO302000GetSchema(\StructType\SO302000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO302000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO301000GetProcessStatusResponse|\StructType\SO301000GetSchemaResponse|\StructType\SO302000GetProcessStatusResponse|\StructType\SO302000GetSchemaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
