<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOC ServiceType
 * @subpackage Services
 */
class SOC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO301000Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO301000Clear $parameters
     * @return \StructType\SO301000ClearResponse|bool
     */
    public function SO301000Clear(\StructType\SO301000Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO301000Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO302000Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO302000Clear $parameters
     * @return \StructType\SO302000ClearResponse|bool
     */
    public function SO302000Clear(\StructType\SO302000Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO302000Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO301000ClearResponse|\StructType\SO302000ClearResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
