<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for POI ServiceType
 * @subpackage Services
 */
class POI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PO301000Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO301000Import $parameters
     * @return \StructType\PO301000ImportResponse|bool
     */
    public function PO301000Import(\StructType\PO301000Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO301000Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO302000Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO302000Import $parameters
     * @return \StructType\PO302000ImportResponse|bool
     */
    public function PO302000Import(\StructType\PO302000Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO302000Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PO301000ImportResponse|\StructType\PO302000ImportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
