<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for POE ServiceType
 * @subpackage Services
 */
class POE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PO301000Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO301000Export $parameters
     * @return \StructType\PO301000ExportResponse|bool
     */
    public function PO301000Export(\StructType\PO301000Export $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO301000Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO302000Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO302000Export $parameters
     * @return \StructType\PO302000ExportResponse|bool
     */
    public function PO302000Export(\StructType\PO302000Export $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO302000Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PO301000ExportResponse|\StructType\PO302000ExportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
