<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for POC ServiceType
 * @subpackage Services
 */
class POC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PO301000Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO301000Clear $parameters
     * @return \StructType\PO301000ClearResponse|bool
     */
    public function PO301000Clear(\StructType\PO301000Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO301000Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO302000Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO302000Clear $parameters
     * @return \StructType\PO302000ClearResponse|bool
     */
    public function PO302000Clear(\StructType\PO302000Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO302000Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PO301000ClearResponse|\StructType\PO302000ClearResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
