<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for CAS ServiceType
 * @subpackage Services
 */
class CAS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CA304000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CA304000SetSchema $parameters
     * @return \StructType\CA304000SetSchemaResponse|bool
     */
    public function CA304000SetSchema(\StructType\CA304000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CA304000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CA304000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CA304000Submit $parameters
     * @return \StructType\CA304000SubmitResponse|bool
     */
    public function CA304000Submit(\StructType\CA304000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CA304000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CA304000SetSchemaResponse|\StructType\CA304000SubmitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
