<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for CAI ServiceType
 * @subpackage Services
 */
class CAI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CA304000Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CA304000Import $parameters
     * @return \StructType\CA304000ImportResponse|bool
     */
    public function CA304000Import(\StructType\CA304000Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CA304000Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CA304000ImportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
