<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for CAG ServiceType
 * @subpackage Services
 */
class CAG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CA304000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CA304000GetProcessStatus $parameters
     * @return \StructType\CA304000GetProcessStatusResponse|bool
     */
    public function CA304000GetProcessStatus(\StructType\CA304000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CA304000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CA304000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CA304000GetSchema $parameters
     * @return \StructType\CA304000GetSchemaResponse|bool
     */
    public function CA304000GetSchema(\StructType\CA304000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CA304000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CA304000GetProcessStatusResponse|\StructType\CA304000GetSchemaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
