<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ARS ServiceType
 * @subpackage Services
 */
class ARS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AR302000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR302000SetSchema $parameters
     * @return \StructType\AR302000SetSchemaResponse|bool
     */
    public function AR302000SetSchema(\StructType\AR302000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR302000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR302000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR302000Submit $parameters
     * @return \StructType\AR302000SubmitResponse|bool
     */
    public function AR302000Submit(\StructType\AR302000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR302000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR303000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR303000SetSchema $parameters
     * @return \StructType\AR303000SetSchemaResponse|bool
     */
    public function AR303000SetSchema(\StructType\AR303000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR303000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR303000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR303000Submit $parameters
     * @return \StructType\AR303000SubmitResponse|bool
     */
    public function AR303000Submit(\StructType\AR303000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR303000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AR302000SetSchemaResponse|\StructType\AR302000SubmitResponse|\StructType\AR303000SetSchemaResponse|\StructType\AR303000SubmitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
