<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ARG ServiceType
 * @subpackage Services
 */
class ARG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AR302000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR302000GetProcessStatus $parameters
     * @return \StructType\AR302000GetProcessStatusResponse|bool
     */
    public function AR302000GetProcessStatus(\StructType\AR302000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR302000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR302000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR302000GetSchema $parameters
     * @return \StructType\AR302000GetSchemaResponse|bool
     */
    public function AR302000GetSchema(\StructType\AR302000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR302000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR303000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR303000GetProcessStatus $parameters
     * @return \StructType\AR303000GetProcessStatusResponse|bool
     */
    public function AR303000GetProcessStatus(\StructType\AR303000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR303000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR303000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR303000GetSchema $parameters
     * @return \StructType\AR303000GetSchemaResponse|bool
     */
    public function AR303000GetSchema(\StructType\AR303000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR303000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AR302000GetProcessStatusResponse|\StructType\AR302000GetSchemaResponse|\StructType\AR303000GetProcessStatusResponse|\StructType\AR303000GetSchemaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
