<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ARC ServiceType
 * @subpackage Services
 */
class ARC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AR302000Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR302000Clear $parameters
     * @return \StructType\AR302000ClearResponse|bool
     */
    public function AR302000Clear(\StructType\AR302000Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR302000Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR303000Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR303000Clear $parameters
     * @return \StructType\AR303000ClearResponse|bool
     */
    public function AR303000Clear(\StructType\AR303000Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR303000Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AR302000ClearResponse|\StructType\AR303000ClearResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
