<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for SO301000ArrayOfContent ArrayType
 * @subpackage Arrays
 */
class SO301000ArrayOfContent extends AbstractStructArrayBase
{
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SO301000Content[]
     */
    public $Content;
    /**
     * Constructor method for SO301000ArrayOfContent
     * @uses SO301000ArrayOfContent::setContent()
     * @param \StructType\SO301000Content[] $content
     */
    public function __construct(array $content = array())
    {
        $this
            ->setContent($content);
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SO301000Content[]|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SO301000Content[] $content
     * @return \ArrayType\SO301000ArrayOfContent
     */
    public function setContent(array $content = array())
    {
        foreach ($content as $sO301000ArrayOfContentContentItem) {
            // validation for constraint: itemType
            if (!$sO301000ArrayOfContentContentItem instanceof \StructType\SO301000Content) {
                throw new \InvalidArgumentException(sprintf('The Content property can only contain items of \StructType\SO301000Content, "%s" given', is_object($sO301000ArrayOfContentContentItem) ? get_class($sO301000ArrayOfContentContentItem) : gettype($sO301000ArrayOfContentContentItem)), __LINE__);
            }
        }
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Add item to Content value
     * @throws \InvalidArgumentException
     * @param \StructType\SO301000Content $item
     * @return \ArrayType\SO301000ArrayOfContent
     */
    public function addToContent(\StructType\SO301000Content $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SO301000Content) {
            throw new \InvalidArgumentException(sprintf('The Content property can only contain items of \StructType\SO301000Content, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Content[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SO301000Content|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SO301000Content|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SO301000Content|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SO301000Content|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SO301000Content|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Content
     */
    public function getAttributeName()
    {
        return 'Content';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\SO301000ArrayOfContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
