<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for PO302000ArrayOfContent ArrayType
 * @subpackage Arrays
 */
class PO302000ArrayOfContent extends AbstractStructArrayBase
{
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PO302000Content[]
     */
    public $Content;
    /**
     * Constructor method for PO302000ArrayOfContent
     * @uses PO302000ArrayOfContent::setContent()
     * @param \StructType\PO302000Content[] $content
     */
    public function __construct(array $content = array())
    {
        $this
            ->setContent($content);
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PO302000Content[]|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PO302000Content[] $content
     * @return \ArrayType\PO302000ArrayOfContent
     */
    public function setContent(array $content = array())
    {
        foreach ($content as $pO302000ArrayOfContentContentItem) {
            // validation for constraint: itemType
            if (!$pO302000ArrayOfContentContentItem instanceof \StructType\PO302000Content) {
                throw new \InvalidArgumentException(sprintf('The Content property can only contain items of \StructType\PO302000Content, "%s" given', is_object($pO302000ArrayOfContentContentItem) ? get_class($pO302000ArrayOfContentContentItem) : gettype($pO302000ArrayOfContentContentItem)), __LINE__);
            }
        }
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Add item to Content value
     * @throws \InvalidArgumentException
     * @param \StructType\PO302000Content $item
     * @return \ArrayType\PO302000ArrayOfContent
     */
    public function addToContent(\StructType\PO302000Content $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PO302000Content) {
            throw new \InvalidArgumentException(sprintf('The Content property can only contain items of \StructType\PO302000Content, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Content[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PO302000Content|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PO302000Content|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PO302000Content|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PO302000Content|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PO302000Content|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Content
     */
    public function getAttributeName()
    {
        return 'Content';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\PO302000ArrayOfContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
