<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for IN304000ArrayOfImportResult ArrayType
 * @subpackage Arrays
 */
class IN304000ArrayOfImportResult extends AbstractStructArrayBase
{
    /**
     * The ImportResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IN304000ImportResult[]
     */
    public $ImportResult;
    /**
     * Constructor method for IN304000ArrayOfImportResult
     * @uses IN304000ArrayOfImportResult::setImportResult()
     * @param \StructType\IN304000ImportResult[] $importResult
     */
    public function __construct(array $importResult = array())
    {
        $this
            ->setImportResult($importResult);
    }
    /**
     * Get ImportResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IN304000ImportResult[]|null
     */
    public function getImportResult()
    {
        return isset($this->ImportResult) ? $this->ImportResult : null;
    }
    /**
     * Set ImportResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IN304000ImportResult[] $importResult
     * @return \ArrayType\IN304000ArrayOfImportResult
     */
    public function setImportResult(array $importResult = array())
    {
        foreach ($importResult as $iN304000ArrayOfImportResultImportResultItem) {
            // validation for constraint: itemType
            if (!$iN304000ArrayOfImportResultImportResultItem instanceof \StructType\IN304000ImportResult) {
                throw new \InvalidArgumentException(sprintf('The ImportResult property can only contain items of \StructType\IN304000ImportResult, "%s" given', is_object($iN304000ArrayOfImportResultImportResultItem) ? get_class($iN304000ArrayOfImportResultImportResultItem) : gettype($iN304000ArrayOfImportResultImportResultItem)), __LINE__);
            }
        }
        if (is_null($importResult) || (is_array($importResult) && empty($importResult))) {
            unset($this->ImportResult);
        } else {
            $this->ImportResult = $importResult;
        }
        return $this;
    }
    /**
     * Add item to ImportResult value
     * @throws \InvalidArgumentException
     * @param \StructType\IN304000ImportResult $item
     * @return \ArrayType\IN304000ArrayOfImportResult
     */
    public function addToImportResult(\StructType\IN304000ImportResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IN304000ImportResult) {
            throw new \InvalidArgumentException(sprintf('The ImportResult property can only contain items of \StructType\IN304000ImportResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ImportResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IN304000ImportResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IN304000ImportResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IN304000ImportResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IN304000ImportResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IN304000ImportResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ImportResult
     */
    public function getAttributeName()
    {
        return 'ImportResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\IN304000ArrayOfImportResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
