<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PO301000OtherInformation StructType
 * @subpackage Structs
 */
class PO301000OtherInformation extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Branch;
    /**
     * The SalesOrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SalesOrderType;
    /**
     * The SalesOrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SalesOrderNbr;
    /**
     * The RequisitionRefNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RequisitionRefNbr;
    /**
     * The PrepaymentRefNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrepaymentRefNbr;
    /**
     * The WorkgroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $WorkgroupID;
    /**
     * The DonTPrint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DonTPrint;
    /**
     * The Printed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Printed;
    /**
     * The DonTEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DonTEmail;
    /**
     * The Emailed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Emailed;
    /**
     * The OpenQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OpenQuantity;
    /**
     * The OpenAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OpenAmount;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PO301000OtherInformationServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for PO301000OtherInformation
     * @uses PO301000OtherInformation::setDisplayName()
     * @uses PO301000OtherInformation::setBranch()
     * @uses PO301000OtherInformation::setSalesOrderType()
     * @uses PO301000OtherInformation::setSalesOrderNbr()
     * @uses PO301000OtherInformation::setRequisitionRefNbr()
     * @uses PO301000OtherInformation::setPrepaymentRefNbr()
     * @uses PO301000OtherInformation::setWorkgroupID()
     * @uses PO301000OtherInformation::setDonTPrint()
     * @uses PO301000OtherInformation::setPrinted()
     * @uses PO301000OtherInformation::setDonTEmail()
     * @uses PO301000OtherInformation::setEmailed()
     * @uses PO301000OtherInformation::setOpenQuantity()
     * @uses PO301000OtherInformation::setOpenAmount()
     * @uses PO301000OtherInformation::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $branch
     * @param \StructType\Field $salesOrderType
     * @param \StructType\Field $salesOrderNbr
     * @param \StructType\Field $requisitionRefNbr
     * @param \StructType\Field $prepaymentRefNbr
     * @param \StructType\Field $workgroupID
     * @param \StructType\Field $donTPrint
     * @param \StructType\Field $printed
     * @param \StructType\Field $donTEmail
     * @param \StructType\Field $emailed
     * @param \StructType\Field $openQuantity
     * @param \StructType\Field $openAmount
     * @param \StructType\PO301000OtherInformationServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $branch = null, \StructType\Field $salesOrderType = null, \StructType\Field $salesOrderNbr = null, \StructType\Field $requisitionRefNbr = null, \StructType\Field $prepaymentRefNbr = null, \StructType\Field $workgroupID = null, \StructType\Field $donTPrint = null, \StructType\Field $printed = null, \StructType\Field $donTEmail = null, \StructType\Field $emailed = null, \StructType\Field $openQuantity = null, \StructType\Field $openAmount = null, \StructType\PO301000OtherInformationServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setBranch($branch)
            ->setSalesOrderType($salesOrderType)
            ->setSalesOrderNbr($salesOrderNbr)
            ->setRequisitionRefNbr($requisitionRefNbr)
            ->setPrepaymentRefNbr($prepaymentRefNbr)
            ->setWorkgroupID($workgroupID)
            ->setDonTPrint($donTPrint)
            ->setPrinted($printed)
            ->setDonTEmail($donTEmail)
            ->setEmailed($emailed)
            ->setOpenQuantity($openQuantity)
            ->setOpenAmount($openAmount)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PO301000OtherInformation
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Branch value
     * @return \StructType\Field|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param \StructType\Field $branch
     * @return \StructType\PO301000OtherInformation
     */
    public function setBranch(\StructType\Field $branch = null)
    {
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get SalesOrderType value
     * @return \StructType\Field|null
     */
    public function getSalesOrderType()
    {
        return $this->SalesOrderType;
    }
    /**
     * Set SalesOrderType value
     * @param \StructType\Field $salesOrderType
     * @return \StructType\PO301000OtherInformation
     */
    public function setSalesOrderType(\StructType\Field $salesOrderType = null)
    {
        $this->SalesOrderType = $salesOrderType;
        return $this;
    }
    /**
     * Get SalesOrderNbr value
     * @return \StructType\Field|null
     */
    public function getSalesOrderNbr()
    {
        return $this->SalesOrderNbr;
    }
    /**
     * Set SalesOrderNbr value
     * @param \StructType\Field $salesOrderNbr
     * @return \StructType\PO301000OtherInformation
     */
    public function setSalesOrderNbr(\StructType\Field $salesOrderNbr = null)
    {
        $this->SalesOrderNbr = $salesOrderNbr;
        return $this;
    }
    /**
     * Get RequisitionRefNbr value
     * @return \StructType\Field|null
     */
    public function getRequisitionRefNbr()
    {
        return $this->RequisitionRefNbr;
    }
    /**
     * Set RequisitionRefNbr value
     * @param \StructType\Field $requisitionRefNbr
     * @return \StructType\PO301000OtherInformation
     */
    public function setRequisitionRefNbr(\StructType\Field $requisitionRefNbr = null)
    {
        $this->RequisitionRefNbr = $requisitionRefNbr;
        return $this;
    }
    /**
     * Get PrepaymentRefNbr value
     * @return \StructType\Field|null
     */
    public function getPrepaymentRefNbr()
    {
        return $this->PrepaymentRefNbr;
    }
    /**
     * Set PrepaymentRefNbr value
     * @param \StructType\Field $prepaymentRefNbr
     * @return \StructType\PO301000OtherInformation
     */
    public function setPrepaymentRefNbr(\StructType\Field $prepaymentRefNbr = null)
    {
        $this->PrepaymentRefNbr = $prepaymentRefNbr;
        return $this;
    }
    /**
     * Get WorkgroupID value
     * @return \StructType\Field|null
     */
    public function getWorkgroupID()
    {
        return $this->WorkgroupID;
    }
    /**
     * Set WorkgroupID value
     * @param \StructType\Field $workgroupID
     * @return \StructType\PO301000OtherInformation
     */
    public function setWorkgroupID(\StructType\Field $workgroupID = null)
    {
        $this->WorkgroupID = $workgroupID;
        return $this;
    }
    /**
     * Get DonTPrint value
     * @return \StructType\Field|null
     */
    public function getDonTPrint()
    {
        return $this->DonTPrint;
    }
    /**
     * Set DonTPrint value
     * @param \StructType\Field $donTPrint
     * @return \StructType\PO301000OtherInformation
     */
    public function setDonTPrint(\StructType\Field $donTPrint = null)
    {
        $this->DonTPrint = $donTPrint;
        return $this;
    }
    /**
     * Get Printed value
     * @return \StructType\Field|null
     */
    public function getPrinted()
    {
        return $this->Printed;
    }
    /**
     * Set Printed value
     * @param \StructType\Field $printed
     * @return \StructType\PO301000OtherInformation
     */
    public function setPrinted(\StructType\Field $printed = null)
    {
        $this->Printed = $printed;
        return $this;
    }
    /**
     * Get DonTEmail value
     * @return \StructType\Field|null
     */
    public function getDonTEmail()
    {
        return $this->DonTEmail;
    }
    /**
     * Set DonTEmail value
     * @param \StructType\Field $donTEmail
     * @return \StructType\PO301000OtherInformation
     */
    public function setDonTEmail(\StructType\Field $donTEmail = null)
    {
        $this->DonTEmail = $donTEmail;
        return $this;
    }
    /**
     * Get Emailed value
     * @return \StructType\Field|null
     */
    public function getEmailed()
    {
        return $this->Emailed;
    }
    /**
     * Set Emailed value
     * @param \StructType\Field $emailed
     * @return \StructType\PO301000OtherInformation
     */
    public function setEmailed(\StructType\Field $emailed = null)
    {
        $this->Emailed = $emailed;
        return $this;
    }
    /**
     * Get OpenQuantity value
     * @return \StructType\Field|null
     */
    public function getOpenQuantity()
    {
        return $this->OpenQuantity;
    }
    /**
     * Set OpenQuantity value
     * @param \StructType\Field $openQuantity
     * @return \StructType\PO301000OtherInformation
     */
    public function setOpenQuantity(\StructType\Field $openQuantity = null)
    {
        $this->OpenQuantity = $openQuantity;
        return $this;
    }
    /**
     * Get OpenAmount value
     * @return \StructType\Field|null
     */
    public function getOpenAmount()
    {
        return $this->OpenAmount;
    }
    /**
     * Set OpenAmount value
     * @param \StructType\Field $openAmount
     * @return \StructType\PO301000OtherInformation
     */
    public function setOpenAmount(\StructType\Field $openAmount = null)
    {
        $this->OpenAmount = $openAmount;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\PO301000OtherInformationServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\PO301000OtherInformationServiceCommands $serviceCommands
     * @return \StructType\PO301000OtherInformation
     */
    public function setServiceCommands(\StructType\PO301000OtherInformationServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PO301000OtherInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
