<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PO301000Demand StructType
 * @subpackage Structs
 */
class PO301000Demand extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The Requested
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Requested;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Customer;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Warehouse;
    /**
     * The OrigUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrigUOM;
    /**
     * The OrigQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrigQuantity;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Quantity;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Active;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PO301000DemandServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for PO301000Demand
     * @uses PO301000Demand::setDisplayName()
     * @uses PO301000Demand::setOrderType()
     * @uses PO301000Demand::setOrderNbr()
     * @uses PO301000Demand::setRequested()
     * @uses PO301000Demand::setCustomer()
     * @uses PO301000Demand::setWarehouse()
     * @uses PO301000Demand::setOrigUOM()
     * @uses PO301000Demand::setOrigQuantity()
     * @uses PO301000Demand::setUOM()
     * @uses PO301000Demand::setQuantity()
     * @uses PO301000Demand::setActive()
     * @uses PO301000Demand::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\Field $requested
     * @param \StructType\Field $customer
     * @param \StructType\Field $warehouse
     * @param \StructType\Field $origUOM
     * @param \StructType\Field $origQuantity
     * @param \StructType\Field $uOM
     * @param \StructType\Field $quantity
     * @param \StructType\Field $active
     * @param \StructType\PO301000DemandServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\Field $requested = null, \StructType\Field $customer = null, \StructType\Field $warehouse = null, \StructType\Field $origUOM = null, \StructType\Field $origQuantity = null, \StructType\Field $uOM = null, \StructType\Field $quantity = null, \StructType\Field $active = null, \StructType\PO301000DemandServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setRequested($requested)
            ->setCustomer($customer)
            ->setWarehouse($warehouse)
            ->setOrigUOM($origUOM)
            ->setOrigQuantity($origQuantity)
            ->setUOM($uOM)
            ->setQuantity($quantity)
            ->setActive($active)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PO301000Demand
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\PO301000Demand
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\PO301000Demand
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get Requested value
     * @return \StructType\Field|null
     */
    public function getRequested()
    {
        return $this->Requested;
    }
    /**
     * Set Requested value
     * @param \StructType\Field $requested
     * @return \StructType\PO301000Demand
     */
    public function setRequested(\StructType\Field $requested = null)
    {
        $this->Requested = $requested;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\Field|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\Field $customer
     * @return \StructType\PO301000Demand
     */
    public function setCustomer(\StructType\Field $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Warehouse value
     * @return \StructType\Field|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param \StructType\Field $warehouse
     * @return \StructType\PO301000Demand
     */
    public function setWarehouse(\StructType\Field $warehouse = null)
    {
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get OrigUOM value
     * @return \StructType\Field|null
     */
    public function getOrigUOM()
    {
        return $this->OrigUOM;
    }
    /**
     * Set OrigUOM value
     * @param \StructType\Field $origUOM
     * @return \StructType\PO301000Demand
     */
    public function setOrigUOM(\StructType\Field $origUOM = null)
    {
        $this->OrigUOM = $origUOM;
        return $this;
    }
    /**
     * Get OrigQuantity value
     * @return \StructType\Field|null
     */
    public function getOrigQuantity()
    {
        return $this->OrigQuantity;
    }
    /**
     * Set OrigQuantity value
     * @param \StructType\Field $origQuantity
     * @return \StructType\PO301000Demand
     */
    public function setOrigQuantity(\StructType\Field $origQuantity = null)
    {
        $this->OrigQuantity = $origQuantity;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\PO301000Demand
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Field|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Field $quantity
     * @return \StructType\PO301000Demand
     */
    public function setQuantity(\StructType\Field $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Active value
     * @return \StructType\Field|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param \StructType\Field $active
     * @return \StructType\PO301000Demand
     */
    public function setActive(\StructType\Field $active = null)
    {
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\PO301000DemandServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\PO301000DemandServiceCommands $serviceCommands
     * @return \StructType\PO301000Demand
     */
    public function setServiceCommands(\StructType\PO301000DemandServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PO301000Demand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
