<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IN304000TransactionDetails StructType
 * @subpackage Structs
 */
class IN304000TransactionDetails extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The ToLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ToLocationID;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Quantity;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReasonCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The NoteText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Availability;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IN304000TransactionDetailsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for IN304000TransactionDetails
     * @uses IN304000TransactionDetails::setDisplayName()
     * @uses IN304000TransactionDetails::setInventoryID()
     * @uses IN304000TransactionDetails::setLocation()
     * @uses IN304000TransactionDetails::setToLocationID()
     * @uses IN304000TransactionDetails::setQuantity()
     * @uses IN304000TransactionDetails::setUOM()
     * @uses IN304000TransactionDetails::setReasonCode()
     * @uses IN304000TransactionDetails::setDescription()
     * @uses IN304000TransactionDetails::setNoteText()
     * @uses IN304000TransactionDetails::setAvailability()
     * @uses IN304000TransactionDetails::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $location
     * @param \StructType\Field $toLocationID
     * @param \StructType\Field $quantity
     * @param \StructType\Field $uOM
     * @param \StructType\Field $reasonCode
     * @param \StructType\Field $description
     * @param \StructType\Field $noteText
     * @param \StructType\Field $availability
     * @param \StructType\IN304000TransactionDetailsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $inventoryID = null, \StructType\Field $location = null, \StructType\Field $toLocationID = null, \StructType\Field $quantity = null, \StructType\Field $uOM = null, \StructType\Field $reasonCode = null, \StructType\Field $description = null, \StructType\Field $noteText = null, \StructType\Field $availability = null, \StructType\IN304000TransactionDetailsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setInventoryID($inventoryID)
            ->setLocation($location)
            ->setToLocationID($toLocationID)
            ->setQuantity($quantity)
            ->setUOM($uOM)
            ->setReasonCode($reasonCode)
            ->setDescription($description)
            ->setNoteText($noteText)
            ->setAvailability($availability)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\IN304000TransactionDetails
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\IN304000TransactionDetails
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\IN304000TransactionDetails
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get ToLocationID value
     * @return \StructType\Field|null
     */
    public function getToLocationID()
    {
        return $this->ToLocationID;
    }
    /**
     * Set ToLocationID value
     * @param \StructType\Field $toLocationID
     * @return \StructType\IN304000TransactionDetails
     */
    public function setToLocationID(\StructType\Field $toLocationID = null)
    {
        $this->ToLocationID = $toLocationID;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Field|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Field $quantity
     * @return \StructType\IN304000TransactionDetails
     */
    public function setQuantity(\StructType\Field $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\IN304000TransactionDetails
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return \StructType\Field|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param \StructType\Field $reasonCode
     * @return \StructType\IN304000TransactionDetails
     */
    public function setReasonCode(\StructType\Field $reasonCode = null)
    {
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\IN304000TransactionDetails
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\IN304000TransactionDetails
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get Availability value
     * @return \StructType\Field|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param \StructType\Field $availability
     * @return \StructType\IN304000TransactionDetails
     */
    public function setAvailability(\StructType\Field $availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\IN304000TransactionDetailsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\IN304000TransactionDetailsServiceCommands $serviceCommands
     * @return \StructType\IN304000TransactionDetails
     */
    public function setServiceCommands(\StructType\IN304000TransactionDetailsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IN304000TransactionDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
