<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IN304000InventoryLookup StructType
 * @subpackage Structs
 */
class IN304000InventoryLookup extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Selected
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Selected;
    /**
     * The QtySelected
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtySelected;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Warehouse;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The ItemClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ItemClassID;
    /**
     * The ItemClassDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ItemClassDescription;
    /**
     * The PriceClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PriceClassID;
    /**
     * The PriceClassDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PriceClassDescription;
    /**
     * The InventoryIDInventoryCD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryIDInventoryCD;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The BaseUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $BaseUnit;
    /**
     * The QtyAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyAvailable;
    /**
     * The QtyOnHand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyOnHand;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IN304000InventoryLookupServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for IN304000InventoryLookup
     * @uses IN304000InventoryLookup::setDisplayName()
     * @uses IN304000InventoryLookup::setSelected()
     * @uses IN304000InventoryLookup::setQtySelected()
     * @uses IN304000InventoryLookup::setWarehouse()
     * @uses IN304000InventoryLookup::setLocation()
     * @uses IN304000InventoryLookup::setItemClassID()
     * @uses IN304000InventoryLookup::setItemClassDescription()
     * @uses IN304000InventoryLookup::setPriceClassID()
     * @uses IN304000InventoryLookup::setPriceClassDescription()
     * @uses IN304000InventoryLookup::setInventoryIDInventoryCD()
     * @uses IN304000InventoryLookup::setDescription()
     * @uses IN304000InventoryLookup::setBaseUnit()
     * @uses IN304000InventoryLookup::setQtyAvailable()
     * @uses IN304000InventoryLookup::setQtyOnHand()
     * @uses IN304000InventoryLookup::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $selected
     * @param \StructType\Field $qtySelected
     * @param \StructType\Field $warehouse
     * @param \StructType\Field $location
     * @param \StructType\Field $itemClassID
     * @param \StructType\Field $itemClassDescription
     * @param \StructType\Field $priceClassID
     * @param \StructType\Field $priceClassDescription
     * @param \StructType\Field $inventoryIDInventoryCD
     * @param \StructType\Field $description
     * @param \StructType\Field $baseUnit
     * @param \StructType\Field $qtyAvailable
     * @param \StructType\Field $qtyOnHand
     * @param \StructType\IN304000InventoryLookupServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $selected = null, \StructType\Field $qtySelected = null, \StructType\Field $warehouse = null, \StructType\Field $location = null, \StructType\Field $itemClassID = null, \StructType\Field $itemClassDescription = null, \StructType\Field $priceClassID = null, \StructType\Field $priceClassDescription = null, \StructType\Field $inventoryIDInventoryCD = null, \StructType\Field $description = null, \StructType\Field $baseUnit = null, \StructType\Field $qtyAvailable = null, \StructType\Field $qtyOnHand = null, \StructType\IN304000InventoryLookupServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setSelected($selected)
            ->setQtySelected($qtySelected)
            ->setWarehouse($warehouse)
            ->setLocation($location)
            ->setItemClassID($itemClassID)
            ->setItemClassDescription($itemClassDescription)
            ->setPriceClassID($priceClassID)
            ->setPriceClassDescription($priceClassDescription)
            ->setInventoryIDInventoryCD($inventoryIDInventoryCD)
            ->setDescription($description)
            ->setBaseUnit($baseUnit)
            ->setQtyAvailable($qtyAvailable)
            ->setQtyOnHand($qtyOnHand)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\IN304000InventoryLookup
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Selected value
     * @return \StructType\Field|null
     */
    public function getSelected()
    {
        return $this->Selected;
    }
    /**
     * Set Selected value
     * @param \StructType\Field $selected
     * @return \StructType\IN304000InventoryLookup
     */
    public function setSelected(\StructType\Field $selected = null)
    {
        $this->Selected = $selected;
        return $this;
    }
    /**
     * Get QtySelected value
     * @return \StructType\Field|null
     */
    public function getQtySelected()
    {
        return $this->QtySelected;
    }
    /**
     * Set QtySelected value
     * @param \StructType\Field $qtySelected
     * @return \StructType\IN304000InventoryLookup
     */
    public function setQtySelected(\StructType\Field $qtySelected = null)
    {
        $this->QtySelected = $qtySelected;
        return $this;
    }
    /**
     * Get Warehouse value
     * @return \StructType\Field|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param \StructType\Field $warehouse
     * @return \StructType\IN304000InventoryLookup
     */
    public function setWarehouse(\StructType\Field $warehouse = null)
    {
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\IN304000InventoryLookup
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get ItemClassID value
     * @return \StructType\Field|null
     */
    public function getItemClassID()
    {
        return $this->ItemClassID;
    }
    /**
     * Set ItemClassID value
     * @param \StructType\Field $itemClassID
     * @return \StructType\IN304000InventoryLookup
     */
    public function setItemClassID(\StructType\Field $itemClassID = null)
    {
        $this->ItemClassID = $itemClassID;
        return $this;
    }
    /**
     * Get ItemClassDescription value
     * @return \StructType\Field|null
     */
    public function getItemClassDescription()
    {
        return $this->ItemClassDescription;
    }
    /**
     * Set ItemClassDescription value
     * @param \StructType\Field $itemClassDescription
     * @return \StructType\IN304000InventoryLookup
     */
    public function setItemClassDescription(\StructType\Field $itemClassDescription = null)
    {
        $this->ItemClassDescription = $itemClassDescription;
        return $this;
    }
    /**
     * Get PriceClassID value
     * @return \StructType\Field|null
     */
    public function getPriceClassID()
    {
        return $this->PriceClassID;
    }
    /**
     * Set PriceClassID value
     * @param \StructType\Field $priceClassID
     * @return \StructType\IN304000InventoryLookup
     */
    public function setPriceClassID(\StructType\Field $priceClassID = null)
    {
        $this->PriceClassID = $priceClassID;
        return $this;
    }
    /**
     * Get PriceClassDescription value
     * @return \StructType\Field|null
     */
    public function getPriceClassDescription()
    {
        return $this->PriceClassDescription;
    }
    /**
     * Set PriceClassDescription value
     * @param \StructType\Field $priceClassDescription
     * @return \StructType\IN304000InventoryLookup
     */
    public function setPriceClassDescription(\StructType\Field $priceClassDescription = null)
    {
        $this->PriceClassDescription = $priceClassDescription;
        return $this;
    }
    /**
     * Get InventoryIDInventoryCD value
     * @return \StructType\Field|null
     */
    public function getInventoryIDInventoryCD()
    {
        return $this->InventoryIDInventoryCD;
    }
    /**
     * Set InventoryIDInventoryCD value
     * @param \StructType\Field $inventoryIDInventoryCD
     * @return \StructType\IN304000InventoryLookup
     */
    public function setInventoryIDInventoryCD(\StructType\Field $inventoryIDInventoryCD = null)
    {
        $this->InventoryIDInventoryCD = $inventoryIDInventoryCD;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\IN304000InventoryLookup
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get BaseUnit value
     * @return \StructType\Field|null
     */
    public function getBaseUnit()
    {
        return $this->BaseUnit;
    }
    /**
     * Set BaseUnit value
     * @param \StructType\Field $baseUnit
     * @return \StructType\IN304000InventoryLookup
     */
    public function setBaseUnit(\StructType\Field $baseUnit = null)
    {
        $this->BaseUnit = $baseUnit;
        return $this;
    }
    /**
     * Get QtyAvailable value
     * @return \StructType\Field|null
     */
    public function getQtyAvailable()
    {
        return $this->QtyAvailable;
    }
    /**
     * Set QtyAvailable value
     * @param \StructType\Field $qtyAvailable
     * @return \StructType\IN304000InventoryLookup
     */
    public function setQtyAvailable(\StructType\Field $qtyAvailable = null)
    {
        $this->QtyAvailable = $qtyAvailable;
        return $this;
    }
    /**
     * Get QtyOnHand value
     * @return \StructType\Field|null
     */
    public function getQtyOnHand()
    {
        return $this->QtyOnHand;
    }
    /**
     * Set QtyOnHand value
     * @param \StructType\Field $qtyOnHand
     * @return \StructType\IN304000InventoryLookup
     */
    public function setQtyOnHand(\StructType\Field $qtyOnHand = null)
    {
        $this->QtyOnHand = $qtyOnHand;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\IN304000InventoryLookupServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\IN304000InventoryLookupServiceCommands $serviceCommands
     * @return \StructType\IN304000InventoryLookup
     */
    public function setServiceCommands(\StructType\IN304000InventoryLookupServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IN304000InventoryLookup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
