<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Command StructType
 * @subpackage Structs
 */
class Command extends AbstractStructBase
{
    /**
     * The FieldName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldName;
    /**
     * The ObjectName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObjectName;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Commit
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Commit;
    /**
     * The IgnoreError
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IgnoreError;
    /**
     * The LinkedCommand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Command
     */
    public $LinkedCommand;
    /**
     * The Descriptor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ElementDescriptor
     */
    public $Descriptor;
    /**
     * Constructor method for Command
     * @uses Command::setFieldName()
     * @uses Command::setObjectName()
     * @uses Command::setValue()
     * @uses Command::setCommit()
     * @uses Command::setIgnoreError()
     * @uses Command::setLinkedCommand()
     * @uses Command::setDescriptor()
     * @param string $fieldName
     * @param string $objectName
     * @param string $value
     * @param bool $commit
     * @param bool $ignoreError
     * @param \StructType\Command $linkedCommand
     * @param \StructType\ElementDescriptor $descriptor
     */
    public function __construct($fieldName = null, $objectName = null, $value = null, $commit = false, $ignoreError = false, \StructType\Command $linkedCommand = null, \StructType\ElementDescriptor $descriptor = null)
    {
        $this
            ->setFieldName($fieldName)
            ->setObjectName($objectName)
            ->setValue($value)
            ->setCommit($commit)
            ->setIgnoreError($ignoreError)
            ->setLinkedCommand($linkedCommand)
            ->setDescriptor($descriptor);
    }
    /**
     * Get FieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->FieldName;
    }
    /**
     * Set FieldName value
     * @param string $fieldName
     * @return \StructType\Command
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fieldName)), __LINE__);
        }
        $this->FieldName = $fieldName;
        return $this;
    }
    /**
     * Get ObjectName value
     * @return string|null
     */
    public function getObjectName()
    {
        return $this->ObjectName;
    }
    /**
     * Set ObjectName value
     * @param string $objectName
     * @return \StructType\Command
     */
    public function setObjectName($objectName = null)
    {
        // validation for constraint: string
        if (!is_null($objectName) && !is_string($objectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectName)), __LINE__);
        }
        $this->ObjectName = $objectName;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Command
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Commit value
     * @return bool|null
     */
    public function getCommit()
    {
        return $this->Commit;
    }
    /**
     * Set Commit value
     * @param bool $commit
     * @return \StructType\Command
     */
    public function setCommit($commit = false)
    {
        $this->Commit = $commit;
        return $this;
    }
    /**
     * Get IgnoreError value
     * @return bool|null
     */
    public function getIgnoreError()
    {
        return $this->IgnoreError;
    }
    /**
     * Set IgnoreError value
     * @param bool $ignoreError
     * @return \StructType\Command
     */
    public function setIgnoreError($ignoreError = false)
    {
        $this->IgnoreError = $ignoreError;
        return $this;
    }
    /**
     * Get LinkedCommand value
     * @return \StructType\Command|null
     */
    public function getLinkedCommand()
    {
        return $this->LinkedCommand;
    }
    /**
     * Set LinkedCommand value
     * @param \StructType\Command $linkedCommand
     * @return \StructType\Command
     */
    public function setLinkedCommand(\StructType\Command $linkedCommand = null)
    {
        $this->LinkedCommand = $linkedCommand;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return \StructType\ElementDescriptor|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param \StructType\ElementDescriptor $descriptor
     * @return \StructType\Command
     */
    public function setDescriptor(\StructType\ElementDescriptor $descriptor = null)
    {
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Command
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
