<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CA304000TaxDetails StructType
 * @subpackage Structs
 */
class CA304000TaxDetails extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The TaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxRate;
    /**
     * The TaxableAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxAmount;
    /**
     * The DeductibleTaxRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DeductibleTaxRate;
    /**
     * The ExpenseAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExpenseAmount;
    /**
     * The TaxType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxType;
    /**
     * The PendingVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PendingVAT;
    /**
     * The ReverseVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReverseVAT;
    /**
     * The IncludeInVATExemptTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $IncludeInVATExemptTotal;
    /**
     * The StatisticalVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $StatisticalVAT;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CA304000TaxDetailsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for CA304000TaxDetails
     * @uses CA304000TaxDetails::setDisplayName()
     * @uses CA304000TaxDetails::setTaxID()
     * @uses CA304000TaxDetails::setTaxRate()
     * @uses CA304000TaxDetails::setTaxableAmount()
     * @uses CA304000TaxDetails::setTaxAmount()
     * @uses CA304000TaxDetails::setDeductibleTaxRate()
     * @uses CA304000TaxDetails::setExpenseAmount()
     * @uses CA304000TaxDetails::setTaxType()
     * @uses CA304000TaxDetails::setPendingVAT()
     * @uses CA304000TaxDetails::setReverseVAT()
     * @uses CA304000TaxDetails::setIncludeInVATExemptTotal()
     * @uses CA304000TaxDetails::setStatisticalVAT()
     * @uses CA304000TaxDetails::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $taxID
     * @param \StructType\Field $taxRate
     * @param \StructType\Field $taxableAmount
     * @param \StructType\Field $taxAmount
     * @param \StructType\Field $deductibleTaxRate
     * @param \StructType\Field $expenseAmount
     * @param \StructType\Field $taxType
     * @param \StructType\Field $pendingVAT
     * @param \StructType\Field $reverseVAT
     * @param \StructType\Field $includeInVATExemptTotal
     * @param \StructType\Field $statisticalVAT
     * @param \StructType\CA304000TaxDetailsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $taxID = null, \StructType\Field $taxRate = null, \StructType\Field $taxableAmount = null, \StructType\Field $taxAmount = null, \StructType\Field $deductibleTaxRate = null, \StructType\Field $expenseAmount = null, \StructType\Field $taxType = null, \StructType\Field $pendingVAT = null, \StructType\Field $reverseVAT = null, \StructType\Field $includeInVATExemptTotal = null, \StructType\Field $statisticalVAT = null, \StructType\CA304000TaxDetailsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate)
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setDeductibleTaxRate($deductibleTaxRate)
            ->setExpenseAmount($expenseAmount)
            ->setTaxType($taxType)
            ->setPendingVAT($pendingVAT)
            ->setReverseVAT($reverseVAT)
            ->setIncludeInVATExemptTotal($includeInVATExemptTotal)
            ->setStatisticalVAT($statisticalVAT)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\CA304000TaxDetails
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get TaxID value
     * @return \StructType\Field|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param \StructType\Field $taxID
     * @return \StructType\CA304000TaxDetails
     */
    public function setTaxID(\StructType\Field $taxID = null)
    {
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return \StructType\Field|null
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param \StructType\Field $taxRate
     * @return \StructType\CA304000TaxDetails
     */
    public function setTaxRate(\StructType\Field $taxRate = null)
    {
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get TaxableAmount value
     * @return \StructType\Field|null
     */
    public function getTaxableAmount()
    {
        return $this->TaxableAmount;
    }
    /**
     * Set TaxableAmount value
     * @param \StructType\Field $taxableAmount
     * @return \StructType\CA304000TaxDetails
     */
    public function setTaxableAmount(\StructType\Field $taxableAmount = null)
    {
        $this->TaxableAmount = $taxableAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return \StructType\Field|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \StructType\Field $taxAmount
     * @return \StructType\CA304000TaxDetails
     */
    public function setTaxAmount(\StructType\Field $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get DeductibleTaxRate value
     * @return \StructType\Field|null
     */
    public function getDeductibleTaxRate()
    {
        return $this->DeductibleTaxRate;
    }
    /**
     * Set DeductibleTaxRate value
     * @param \StructType\Field $deductibleTaxRate
     * @return \StructType\CA304000TaxDetails
     */
    public function setDeductibleTaxRate(\StructType\Field $deductibleTaxRate = null)
    {
        $this->DeductibleTaxRate = $deductibleTaxRate;
        return $this;
    }
    /**
     * Get ExpenseAmount value
     * @return \StructType\Field|null
     */
    public function getExpenseAmount()
    {
        return $this->ExpenseAmount;
    }
    /**
     * Set ExpenseAmount value
     * @param \StructType\Field $expenseAmount
     * @return \StructType\CA304000TaxDetails
     */
    public function setExpenseAmount(\StructType\Field $expenseAmount = null)
    {
        $this->ExpenseAmount = $expenseAmount;
        return $this;
    }
    /**
     * Get TaxType value
     * @return \StructType\Field|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param \StructType\Field $taxType
     * @return \StructType\CA304000TaxDetails
     */
    public function setTaxType(\StructType\Field $taxType = null)
    {
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get PendingVAT value
     * @return \StructType\Field|null
     */
    public function getPendingVAT()
    {
        return $this->PendingVAT;
    }
    /**
     * Set PendingVAT value
     * @param \StructType\Field $pendingVAT
     * @return \StructType\CA304000TaxDetails
     */
    public function setPendingVAT(\StructType\Field $pendingVAT = null)
    {
        $this->PendingVAT = $pendingVAT;
        return $this;
    }
    /**
     * Get ReverseVAT value
     * @return \StructType\Field|null
     */
    public function getReverseVAT()
    {
        return $this->ReverseVAT;
    }
    /**
     * Set ReverseVAT value
     * @param \StructType\Field $reverseVAT
     * @return \StructType\CA304000TaxDetails
     */
    public function setReverseVAT(\StructType\Field $reverseVAT = null)
    {
        $this->ReverseVAT = $reverseVAT;
        return $this;
    }
    /**
     * Get IncludeInVATExemptTotal value
     * @return \StructType\Field|null
     */
    public function getIncludeInVATExemptTotal()
    {
        return $this->IncludeInVATExemptTotal;
    }
    /**
     * Set IncludeInVATExemptTotal value
     * @param \StructType\Field $includeInVATExemptTotal
     * @return \StructType\CA304000TaxDetails
     */
    public function setIncludeInVATExemptTotal(\StructType\Field $includeInVATExemptTotal = null)
    {
        $this->IncludeInVATExemptTotal = $includeInVATExemptTotal;
        return $this;
    }
    /**
     * Get StatisticalVAT value
     * @return \StructType\Field|null
     */
    public function getStatisticalVAT()
    {
        return $this->StatisticalVAT;
    }
    /**
     * Set StatisticalVAT value
     * @param \StructType\Field $statisticalVAT
     * @return \StructType\CA304000TaxDetails
     */
    public function setStatisticalVAT(\StructType\Field $statisticalVAT = null)
    {
        $this->StatisticalVAT = $statisticalVAT;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\CA304000TaxDetailsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\CA304000TaxDetailsServiceCommands $serviceCommands
     * @return \StructType\CA304000TaxDetails
     */
    public function setServiceCommands(\StructType\CA304000TaxDetailsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CA304000TaxDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
