<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AR303000GeneralInfo StructType
 * @subpackage Structs
 */
class AR303000GeneralInfo extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The AccountRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AccountRef;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AR303000GeneralInfoServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for AR303000GeneralInfo
     * @uses AR303000GeneralInfo::setDisplayName()
     * @uses AR303000GeneralInfo::setAccountRef()
     * @uses AR303000GeneralInfo::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $accountRef
     * @param \StructType\AR303000GeneralInfoServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $accountRef = null, \StructType\AR303000GeneralInfoServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setAccountRef($accountRef)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\AR303000GeneralInfo
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get AccountRef value
     * @return \StructType\Field|null
     */
    public function getAccountRef()
    {
        return $this->AccountRef;
    }
    /**
     * Set AccountRef value
     * @param \StructType\Field $accountRef
     * @return \StructType\AR303000GeneralInfo
     */
    public function setAccountRef(\StructType\Field $accountRef = null)
    {
        $this->AccountRef = $accountRef;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AR303000GeneralInfoServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AR303000GeneralInfoServiceCommands $serviceCommands
     * @return \StructType\AR303000GeneralInfo
     */
    public function setServiceCommands(\StructType\AR303000GeneralInfoServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AR303000GeneralInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
