<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AR303000GLAccounts StructType
 * @subpackage Structs
 */
class AR303000GLAccounts extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ARAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ARAccount;
    /**
     * The ARSub
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ARSub;
    /**
     * The SalesAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SalesAccount;
    /**
     * The SalesSub
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SalesSub;
    /**
     * The DiscountAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountAccount;
    /**
     * The DiscountSub
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountSub;
    /**
     * The FreightAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FreightAccount;
    /**
     * The FreightSub
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FreightSub;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AR303000GLAccountsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for AR303000GLAccounts
     * @uses AR303000GLAccounts::setDisplayName()
     * @uses AR303000GLAccounts::setARAccount()
     * @uses AR303000GLAccounts::setARSub()
     * @uses AR303000GLAccounts::setSalesAccount()
     * @uses AR303000GLAccounts::setSalesSub()
     * @uses AR303000GLAccounts::setDiscountAccount()
     * @uses AR303000GLAccounts::setDiscountSub()
     * @uses AR303000GLAccounts::setFreightAccount()
     * @uses AR303000GLAccounts::setFreightSub()
     * @uses AR303000GLAccounts::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $aRAccount
     * @param \StructType\Field $aRSub
     * @param \StructType\Field $salesAccount
     * @param \StructType\Field $salesSub
     * @param \StructType\Field $discountAccount
     * @param \StructType\Field $discountSub
     * @param \StructType\Field $freightAccount
     * @param \StructType\Field $freightSub
     * @param \StructType\AR303000GLAccountsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $aRAccount = null, \StructType\Field $aRSub = null, \StructType\Field $salesAccount = null, \StructType\Field $salesSub = null, \StructType\Field $discountAccount = null, \StructType\Field $discountSub = null, \StructType\Field $freightAccount = null, \StructType\Field $freightSub = null, \StructType\AR303000GLAccountsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setARAccount($aRAccount)
            ->setARSub($aRSub)
            ->setSalesAccount($salesAccount)
            ->setSalesSub($salesSub)
            ->setDiscountAccount($discountAccount)
            ->setDiscountSub($discountSub)
            ->setFreightAccount($freightAccount)
            ->setFreightSub($freightSub)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\AR303000GLAccounts
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ARAccount value
     * @return \StructType\Field|null
     */
    public function getARAccount()
    {
        return $this->ARAccount;
    }
    /**
     * Set ARAccount value
     * @param \StructType\Field $aRAccount
     * @return \StructType\AR303000GLAccounts
     */
    public function setARAccount(\StructType\Field $aRAccount = null)
    {
        $this->ARAccount = $aRAccount;
        return $this;
    }
    /**
     * Get ARSub value
     * @return \StructType\Field|null
     */
    public function getARSub()
    {
        return $this->ARSub;
    }
    /**
     * Set ARSub value
     * @param \StructType\Field $aRSub
     * @return \StructType\AR303000GLAccounts
     */
    public function setARSub(\StructType\Field $aRSub = null)
    {
        $this->ARSub = $aRSub;
        return $this;
    }
    /**
     * Get SalesAccount value
     * @return \StructType\Field|null
     */
    public function getSalesAccount()
    {
        return $this->SalesAccount;
    }
    /**
     * Set SalesAccount value
     * @param \StructType\Field $salesAccount
     * @return \StructType\AR303000GLAccounts
     */
    public function setSalesAccount(\StructType\Field $salesAccount = null)
    {
        $this->SalesAccount = $salesAccount;
        return $this;
    }
    /**
     * Get SalesSub value
     * @return \StructType\Field|null
     */
    public function getSalesSub()
    {
        return $this->SalesSub;
    }
    /**
     * Set SalesSub value
     * @param \StructType\Field $salesSub
     * @return \StructType\AR303000GLAccounts
     */
    public function setSalesSub(\StructType\Field $salesSub = null)
    {
        $this->SalesSub = $salesSub;
        return $this;
    }
    /**
     * Get DiscountAccount value
     * @return \StructType\Field|null
     */
    public function getDiscountAccount()
    {
        return $this->DiscountAccount;
    }
    /**
     * Set DiscountAccount value
     * @param \StructType\Field $discountAccount
     * @return \StructType\AR303000GLAccounts
     */
    public function setDiscountAccount(\StructType\Field $discountAccount = null)
    {
        $this->DiscountAccount = $discountAccount;
        return $this;
    }
    /**
     * Get DiscountSub value
     * @return \StructType\Field|null
     */
    public function getDiscountSub()
    {
        return $this->DiscountSub;
    }
    /**
     * Set DiscountSub value
     * @param \StructType\Field $discountSub
     * @return \StructType\AR303000GLAccounts
     */
    public function setDiscountSub(\StructType\Field $discountSub = null)
    {
        $this->DiscountSub = $discountSub;
        return $this;
    }
    /**
     * Get FreightAccount value
     * @return \StructType\Field|null
     */
    public function getFreightAccount()
    {
        return $this->FreightAccount;
    }
    /**
     * Set FreightAccount value
     * @param \StructType\Field $freightAccount
     * @return \StructType\AR303000GLAccounts
     */
    public function setFreightAccount(\StructType\Field $freightAccount = null)
    {
        $this->FreightAccount = $freightAccount;
        return $this;
    }
    /**
     * Get FreightSub value
     * @return \StructType\Field|null
     */
    public function getFreightSub()
    {
        return $this->FreightSub;
    }
    /**
     * Set FreightSub value
     * @param \StructType\Field $freightSub
     * @return \StructType\AR303000GLAccounts
     */
    public function setFreightSub(\StructType\Field $freightSub = null)
    {
        $this->FreightSub = $freightSub;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AR303000GLAccountsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AR303000GLAccountsServiceCommands $serviceCommands
     * @return \StructType\AR303000GLAccounts
     */
    public function setServiceCommands(\StructType\AR303000GLAccountsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AR303000GLAccounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
