<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AR303000Attributes StructType
 * @subpackage Structs
 */
class AR303000Attributes extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Attribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Attribute;
    /**
     * The Required
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Required;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Value;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AR303000AttributesServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for AR303000Attributes
     * @uses AR303000Attributes::setDisplayName()
     * @uses AR303000Attributes::setAttribute()
     * @uses AR303000Attributes::setRequired()
     * @uses AR303000Attributes::setValue()
     * @uses AR303000Attributes::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $attribute
     * @param \StructType\Field $required
     * @param \StructType\Field $value
     * @param \StructType\AR303000AttributesServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $attribute = null, \StructType\Field $required = null, \StructType\Field $value = null, \StructType\AR303000AttributesServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setAttribute($attribute)
            ->setRequired($required)
            ->setValue($value)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\AR303000Attributes
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Attribute value
     * @return \StructType\Field|null
     */
    public function getAttribute()
    {
        return $this->Attribute;
    }
    /**
     * Set Attribute value
     * @param \StructType\Field $attribute
     * @return \StructType\AR303000Attributes
     */
    public function setAttribute(\StructType\Field $attribute = null)
    {
        $this->Attribute = $attribute;
        return $this;
    }
    /**
     * Get Required value
     * @return \StructType\Field|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param \StructType\Field $required
     * @return \StructType\AR303000Attributes
     */
    public function setRequired(\StructType\Field $required = null)
    {
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Value value
     * @return \StructType\Field|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \StructType\Field $value
     * @return \StructType\AR303000Attributes
     */
    public function setValue(\StructType\Field $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AR303000AttributesServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AR303000AttributesServiceCommands $serviceCommands
     * @return \StructType\AR303000Attributes
     */
    public function setServiceCommands(\StructType\AR303000AttributesServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AR303000Attributes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
