<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOI ServiceType
 * @subpackage Services
 */
class SOI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO301000Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO301000Import $parameters
     * @return \StructType\SO301000ImportResponse|bool
     */
    public function SO301000Import(\StructType\SO301000Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO301000Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO302000Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO302000Import $parameters
     * @return \StructType\SO302000ImportResponse|bool
     */
    public function SO302000Import(\StructType\SO302000Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO302000Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO301000ImportResponse|\StructType\SO302000ImportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
