<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOE ServiceType
 * @subpackage Services
 */
class SOE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO301000Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO301000Export $parameters
     * @return \StructType\SO301000ExportResponse|bool
     */
    public function SO301000Export(\StructType\SO301000Export $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO301000Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO302000Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO302000Export $parameters
     * @return \StructType\SO302000ExportResponse|bool
     */
    public function SO302000Export(\StructType\SO302000Export $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SO302000Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO301000ExportResponse|\StructType\SO302000ExportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
