<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for INS ServiceType
 * @subpackage Services
 */
class INS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IN202500SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN202500SetSchema $parameters
     * @return \StructType\IN202500SetSchemaResponse|bool
     */
    public function IN202500SetSchema(\StructType\IN202500SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN202500SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN202500Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN202500Submit $parameters
     * @return \StructType\IN202500SubmitResponse|bool
     */
    public function IN202500Submit(\StructType\IN202500Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN202500Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN304000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN304000SetSchema $parameters
     * @return \StructType\IN304000SetSchemaResponse|bool
     */
    public function IN304000SetSchema(\StructType\IN304000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN304000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN304000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN304000Submit $parameters
     * @return \StructType\IN304000SubmitResponse|bool
     */
    public function IN304000Submit(\StructType\IN304000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN304000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IN202500SetSchemaResponse|\StructType\IN202500SubmitResponse|\StructType\IN304000SetSchemaResponse|\StructType\IN304000SubmitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
